/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PostgreSQLDB
extends BaseDB {
    private static final String[] _POSTGRESQL = new String[]{"--", "true", "false", "'01/01/1970'", "current_timestamp", " oid", " bytea", " bool", " timestamp", " double precision", " integer", " bigint", " text", " text", " varchar", "", "commit"};
    private static final boolean _SUPPORTS_QUERYING_AFTER_EXCEPTION = false;

    public static String getCreateRulesSQL(String tableName, String columnName) {
        StringBundler sb = new StringBundler(45);
        sb.append("create or replace rule delete_");
        sb.append(tableName);
        sb.append("_");
        sb.append(columnName);
        sb.append(" as on delete to ");
        sb.append(tableName);
        sb.append(" do also select case when exists(select 1 from ");
        sb.append("pg_catalog.pg_largeobject_metadata where (oid = old.");
        sb.append(columnName);
        sb.append(")) then lo_unlink(old.");
        sb.append(columnName);
        sb.append(") end from ");
        sb.append(tableName);
        sb.append(" where ");
        sb.append(tableName);
        sb.append(".");
        sb.append(columnName);
        sb.append(" = old.");
        sb.append(columnName);
        sb.append(";\ncreate or replace rule update_");
        sb.append(tableName);
        sb.append("_");
        sb.append(columnName);
        sb.append(" as on update to ");
        sb.append(tableName);
        sb.append(" where old.");
        sb.append(columnName);
        sb.append(" is distinct from new.");
        sb.append(columnName);
        sb.append(" and old.");
        sb.append(columnName);
        sb.append(" is not null do also select case when exists(select 1 ");
        sb.append("from pg_catalog.pg_largeobject_metadata where (oid = old.");
        sb.append(columnName);
        sb.append(")) then lo_unlink(old.");
        sb.append(columnName);
        sb.append(") end from ");
        sb.append(tableName);
        sb.append(" where ");
        sb.append(tableName);
        sb.append(".");
        sb.append(columnName);
        sb.append(" = old.");
        sb.append(columnName);
        sb.append(";");
        return sb.toString();
    }

    public PostgreSQLDB(int majorVersion, int minorVersion) {
        super(DBType.POSTGRESQL, majorVersion, minorVersion);
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Index> getIndexes(Connection con) throws SQLException {
        ArrayList<Index> indexes = new ArrayList<Index>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            StringBundler sb = new StringBundler(3);
            sb.append("select indexname, tablename, indexdef from pg_indexes ");
            sb.append("where indexname like 'liferay_%' or indexname like ");
            sb.append("'ix_%'");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString("indexname");
                String tableName = rs.getString("tablename");
                String indexSQL = StringUtil.toLowerCase(StringUtil.trim(rs.getString("indexdef")));
                boolean unique = true;
                if (indexSQL.startsWith("create index ")) {
                    unique = false;
                }
                indexes.add(new Index(indexName, tableName, unique));
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(ps, rs);
        return indexes;
    }

    @Override
    public boolean isSupportsQueryingAfterException() {
        return false;
    }

    @Override
    protected String buildCreateFileContent(String sqlDir, String databaseName, int population) throws IOException {
        StringBundler sb = new StringBundler(14);
        sb.append("drop database ");
        sb.append(databaseName);
        sb.append(";\n");
        sb.append("create database ");
        sb.append(databaseName);
        sb.append(" encoding = 'UNICODE';\n");
        if (population != 0) {
            sb.append("\\c ");
            sb.append(databaseName);
            sb.append(";\n\n");
            sb.append(this.getCreateTablesContent(sqlDir, this.getSuffix(population)));
            sb.append("\n\n");
            sb.append(this.readFile(sqlDir + "/indexes/indexes-postgresql.sql"));
            sb.append("\n\n");
            sb.append(this.readFile(sqlDir + "/sequences/sequences-postgresql.sql"));
        }
        return sb.toString();
    }

    @Override
    protected String getServerName() {
        return "postgresql";
    }

    @Override
    protected String[] getTemplate() {
        return _POSTGRESQL;
    }

    @Override
    protected String reword(String data) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(data));){
            StringBundler sb = new StringBundler();
            StringBundler createRulesSQLSB = new StringBundler();
            String line = null;
            String tableName = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String[] tokens;
                String[] template;
                if (line.startsWith("alter_column_name ")) {
                    template = this.buildColumnNameTokens(line);
                    line = StringUtil.replace("alter table @table@ rename @old-column@ to @new-column@;", REWORD_TEMPLATE, template);
                } else if (line.startsWith("alter_column_type ")) {
                    template = this.buildColumnTypeTokens(line);
                    line = StringUtil.replace("alter table @table@ alter @old-column@ type @type@ using @old-column@::@type@;", REWORD_TEMPLATE, template);
                } else if (line.startsWith("alter_table_name ")) {
                    template = this.buildTableNameTokens(line);
                    line = StringUtil.replace("alter table @old-table@ rename to @new-table@;", RENAME_TABLE_TEMPLATE, template);
                } else if (line.startsWith("create table ")) {
                    tokens = StringUtil.split(line, ' ');
                    tableName = tokens[2];
                } else if (line.contains("drop index")) {
                    tokens = StringUtil.split(line, ' ');
                    line = StringUtil.replace("drop index @index@;", "@index@", tokens[2]);
                } else if (line.contains("drop primary key")) {
                    tokens = StringUtil.split(line, ' ');
                    line = StringUtil.replace("alter table @table@ drop constraint @table@_pkey;", "@table@", tokens[2]);
                } else if (line.contains(this.getTemplateBlob())) {
                    tokens = StringUtil.split(line, ' ');
                    createRulesSQLSB.append("\n");
                    createRulesSQLSB.append(PostgreSQLDB.getCreateRulesSQL(tableName, tokens[0]));
                } else if (line.contains("\\'")) {
                    line = StringUtil.replace(line, "\\'", "''");
                }
                sb.append(line);
                sb.append("\n");
            }
            sb.append(createRulesSQLSB.toString());
            String string = sb.toString();
            return string;
        }
    }
}

