/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;

public class HypersonicDB
extends BaseDB {
    private static final String[] _HYPERSONIC = new String[]{"//", "true", "false", "'1970-01-01 00:00:00'", "now()", " blob", " blob", " bit", " timestamp", " double", " int", " bigint", " longvarchar", " longvarchar", " varchar", "", "commit"};

    public HypersonicDB(int majorVersion, int minorVersion) {
        super(DBType.HYPERSONIC, majorVersion, minorVersion);
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = StringUtil.replace(template, "\\'", "''");
        return template;
    }

    @Override
    protected String buildCreateFileContent(String sqlDir, String databaseName, int population) {
        return null;
    }

    @Override
    protected String getServerName() {
        return "hypersonic";
    }

    @Override
    protected String[] getTemplate() {
        return _HYPERSONIC;
    }

    @Override
    protected String reword(String data) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(data));){
            StringBundler sb = new StringBundler();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String[] template;
                if (line.startsWith("alter_column_name ")) {
                    template = this.buildColumnNameTokens(line);
                    line = StringUtil.replace("alter table @table@ alter column @old-column@ rename to @new-column@;", REWORD_TEMPLATE, template);
                } else if (line.startsWith("alter_column_type ")) {
                    template = this.buildColumnTypeTokens(line);
                    line = StringUtil.replace("alter table @table@ alter column @old-column@ @type@;", REWORD_TEMPLATE, template);
                    line = line.concat(StringUtil.replace("alter table @table@ alter column @old-column@ set @nullable@;", REWORD_TEMPLATE, template));
                } else if (line.startsWith("alter_table_name ")) {
                    template = this.buildTableNameTokens(line);
                    line = StringUtil.replace("alter table @old-table@ rename to @new-table@;", RENAME_TABLE_TEMPLATE, template);
                } else if (line.contains("drop index")) {
                    String[] tokens = StringUtil.split(line, ' ');
                    line = StringUtil.replace("drop index @index@;", "@index@", tokens[2]);
                }
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }
}

