/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.custom.jsp.bag;

import com.liferay.portal.deploy.hot.CustomJspBag;
import com.liferay.portal.kernel.url.URLContainer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;

public abstract class BaseCustomJspBag
implements CustomJspBag {
    private Bundle _bundle;
    private List<String> _customJsps;
    private final URLContainer _urlContainer = new URLContainer(){

        @Override
        public URL getResource(String name) {
            return BaseCustomJspBag.this._bundle.getEntry(name);
        }

        @Override
        public Set<String> getResources(String path) {
            HashSet<String> paths = new HashSet<String>();
            for (String customJsp : BaseCustomJspBag.this._customJsps) {
                if (!customJsp.startsWith(path)) continue;
                paths.add(customJsp);
            }
            return paths;
        }
    };

    @Override
    public String getCustomJspDir() {
        return "META-INF/resources/custom_jsps";
    }

    @Override
    public List<String> getCustomJsps() {
        return this._customJsps;
    }

    @Override
    public URLContainer getURLContainer() {
        return this._urlContainer;
    }

    @Override
    public boolean isCustomJspGlobal() {
        return true;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundle = bundleContext.getBundle();
        this._customJsps = new ArrayList<String>();
        Enumeration enumeration = this._bundle.findEntries(this.getCustomJspDir(), "*.jsp", true);
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            this._customJsps.add(url.getPath());
        }
    }
}

