/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.convert.ConvertException;
import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.MaintenanceUtil;
import org.apache.commons.lang.time.StopWatch;

public abstract class BaseConvertProcess
implements ConvertProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseConvertProcess.class);
    private String[] _paramValues;

    @Override
    public void convert() throws ConvertException {
        try {
            Class<?> clazz;
            if (this.getPath() != null) {
                return;
            }
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            if (_log.isInfoEnabled()) {
                clazz = this.getClass();
                _log.info("Starting conversion for " + clazz.getName());
            }
            this.doConvert();
            if (_log.isInfoEnabled()) {
                clazz = this.getClass();
                _log.info(StringBundler.concat("Finished conversion for ", clazz.getName(), " in ", stopWatch.getTime(), " ms"));
            }
        }
        catch (Exception e) {
            throw new ConvertException(e);
        }
        finally {
            this.setParameterValues(null);
            if (MaintenanceUtil.isMaintaining()) {
                MaintenanceUtil.cancel();
            }
        }
    }

    @Override
    public String getConfigurationErrorMessage() {
        return null;
    }

    @Override
    public abstract String getDescription();

    @Override
    public String getParameterDescription() {
        return null;
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    public String[] getParameterValues() {
        return this._paramValues;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public abstract boolean isEnabled();

    @Override
    public void setParameterValues(String[] values) {
        this._paramValues = values;
    }

    @Override
    public void validate() throws ConvertException {
    }

    protected abstract void doConvert() throws Exception;
}

