/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.metatype.util;

import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class ParameterMapInvocationHandler<S>
implements InvocationHandler {
    private final Object _bean;
    private final Class _clazz;
    private final Map<String, String[]> _parameterMap;
    private final String _parameterPrefix;
    private final String _parameterSuffix;

    public ParameterMapInvocationHandler(Class clazz, Object bean, Map<String, String[]> parameterMap) {
        this(clazz, bean, parameterMap, "", "");
    }

    public ParameterMapInvocationHandler(Class clazz, Object bean, Map<String, String[]> parameterMap, String parameterPrefix, String parameterSuffix) {
        this._clazz = clazz;
        this._bean = bean;
        this._parameterMap = parameterMap;
        this._parameterPrefix = parameterPrefix;
        this._parameterSuffix = parameterSuffix;
    }

    public S createProxy() {
        return (S)ProxyUtil.newProxyInstance(this._clazz.getClassLoader(), new Class[]{this._clazz}, this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws InvocationTargetException {
        Object result = null;
        try {
            result = this._invokeMap(method);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result != null) {
            return result;
        }
        try {
            return this._invokeConfigurationInstance(method, arguments);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String _getMapValue(String name) {
        String[] values = this._getMapValueArray(name);
        if (values == null) {
            return null;
        }
        return values[0];
    }

    private String[] _getMapValueArray(String name) {
        String[] values = this._parameterMap.get(this._parameterPrefix + name + this._parameterSuffix);
        if (values == null || values.length == 0) {
            return null;
        }
        return values;
    }

    private Object _invokeConfigurationInstance(Method method, Object[] arguments) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> clazz = this._bean.getClass();
        method = clazz.getMethod(method.getName(), method.getParameterTypes());
        return method.invoke(this._bean, arguments);
    }

    private Object _invokeMap(Method method) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Boolean.TYPE)) {
            String value = this._getMapValue(method.getName());
            if (value == null) {
                return null;
            }
            return Boolean.valueOf(value);
        }
        if (returnType.equals(Double.TYPE)) {
            String value = this._getMapValue(method.getName());
            if (value == null) {
                return null;
            }
            return Double.valueOf(this._getMapValue(method.getName()));
        }
        if (returnType.equals(Float.TYPE)) {
            String value = this._getMapValue(method.getName());
            if (value == null) {
                return null;
            }
            return Float.valueOf(this._getMapValue(method.getName()));
        }
        if (returnType.equals(Integer.TYPE)) {
            String value = this._getMapValue(method.getName());
            if (value == null) {
                return null;
            }
            return Integer.valueOf(this._getMapValue(method.getName()));
        }
        if (returnType.equals(LocalizedValuesMap.class)) {
            return this._getMapValue(method.getName());
        }
        if (returnType.equals(Long.TYPE)) {
            String value = this._getMapValue(method.getName());
            if (value == null) {
                return null;
            }
            return Long.valueOf(this._getMapValue(method.getName()));
        }
        if (returnType.equals(String.class)) {
            return this._getMapValue(method.getName());
        }
        if (returnType.equals(String[].class)) {
            return this._getMapValueArray(method.getName());
        }
        if (returnType.isEnum()) {
            Method valueOfMethod = returnType.getDeclaredMethod("valueOf", String.class);
            return valueOfMethod.invoke(returnType, (Object[])this._parameterMap.get(method.getName()));
        }
        Constructor<?> constructor = returnType.getConstructor(String.class);
        return constructor.newInstance(this._parameterMap.get(method.getName()));
    }
}

