/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.metatype.bnd.util;

import aQute.bnd.annotation.metatype.Configurable;
import com.liferay.petra.reflect.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ConfigurableUtil {
    private static final AtomicLong _counter = new AtomicLong();
    private static final Method _defineClassMethod;

    public static <T> T createConfigurable(Class<T> clazz, Dictionary<?, ?> properties) {
        return (T)ConfigurableUtil._createConfigurableSnapshot(clazz, Configurable.createConfigurable(clazz, properties));
    }

    public static <T> T createConfigurable(Class<T> clazz, Map<?, ?> properties) {
        return (T)ConfigurableUtil._createConfigurableSnapshot(clazz, Configurable.createConfigurable(clazz, properties));
    }

    private static <T> T _createConfigurableSnapshot(Class<T> interfaceClass, T configurable) {
        String interfaceClassName = interfaceClass.getName();
        String snapshotClassName = interfaceClassName.concat("Snapshot");
        snapshotClassName = snapshotClassName.concat(String.valueOf(_counter.getAndIncrement()));
        try {
            byte[] snapshotClassData = ConfigurableUtil._generateSnapshotClassData(interfaceClass, snapshotClassName, configurable);
            Class snapshotClass = (Class)_defineClassMethod.invoke((Object)interfaceClass.getClassLoader(), snapshotClassName, snapshotClassData, 0, snapshotClassData.length);
            Constructor snapshotClassConstructor = snapshotClass.getConstructor(configurable.getClass());
            return snapshotClassConstructor.newInstance(configurable);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to create snapshot class for " + interfaceClass, t);
        }
    }

    private static <T> byte[] _generateSnapshotClassData(Class<T> interfaceClass, String snapshotClassName, T configurable) throws Exception {
        String snapshotClassBinaryName = ConfigurableUtil._getClassBinaryName(snapshotClassName);
        String objectClassBinaryName = ConfigurableUtil._getClassBinaryName(Object.class.getName());
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(50, 33, snapshotClassBinaryName, null, objectClassBinaryName, new String[]{ConfigurableUtil._getClassBinaryName(interfaceClass.getName())});
        Method[] declaredMethods = interfaceClass.getDeclaredMethods();
        ArrayList<Method> bigStringMethods = new ArrayList<Method>();
        for (Method method : declaredMethods) {
            String result;
            if (method.getReturnType() != String.class || (result = (String)method.invoke(configurable, new Object[0])) == null || result.length() <= 65535) continue;
            bigStringMethods.add(method);
        }
        for (Method method : declaredMethods) {
            Class<?> returnType = method.getReturnType();
            if (returnType.isPrimitive() || returnType.isEnum() || returnType == String.class && !bigStringMethods.contains(method)) continue;
            FieldVisitor fieldVisitor = classWriter.visitField(18, method.getName(), Type.getDescriptor(returnType), null, null);
            fieldVisitor.visitEnd();
        }
        Class<?> configurableClass = configurable.getClass();
        MethodVisitor constructorMethodVisitor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(configurableClass)), null, null);
        constructorMethodVisitor.visitCode();
        constructorMethodVisitor.visitVarInsn(25, 0);
        constructorMethodVisitor.visitMethodInsn(183, objectClassBinaryName, "<init>", "()V", false);
        for (Method method : declaredMethods) {
            Class<?> returnType = method.getReturnType();
            if (returnType.isPrimitive() || returnType.isEnum() || returnType == String.class && !bigStringMethods.contains(method)) continue;
            constructorMethodVisitor.visitVarInsn(25, 0);
            constructorMethodVisitor.visitVarInsn(25, 1);
            String methodName = method.getName();
            constructorMethodVisitor.visitMethodInsn(182, ConfigurableUtil._getClassBinaryName(configurableClass.getName()), methodName, Type.getMethodDescriptor(method), false);
            constructorMethodVisitor.visitFieldInsn(181, snapshotClassBinaryName, methodName, Type.getDescriptor(returnType));
        }
        constructorMethodVisitor.visitInsn(177);
        constructorMethodVisitor.visitMaxs(0, 0);
        constructorMethodVisitor.visitEnd();
        for (Method method : declaredMethods) {
            Object result;
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            MethodVisitor methodVisitor = classWriter.visitMethod(1, methodName, Type.getMethodDescriptor(method), null, null);
            methodVisitor.visitCode();
            method.setAccessible(true);
            if (returnType.isPrimitive() || returnType == String.class && !bigStringMethods.contains(method)) {
                result = method.invoke(configurable, new Object[0]);
                if (result == null) {
                    methodVisitor.visitInsn(1);
                } else {
                    methodVisitor.visitLdcInsn(result);
                }
                Type returnValueType = Type.getType(returnType);
                methodVisitor.visitInsn(returnValueType.getOpcode(172));
            } else if (returnType.isEnum()) {
                result = (Enum)method.invoke(configurable, new Object[0]);
                String fieldName = ((Enum)result).name();
                Field enumField = ReflectionUtil.getDeclaredField(returnType, fieldName);
                methodVisitor.visitFieldInsn(178, ConfigurableUtil._getClassBinaryName(returnType.getName()), fieldName, Type.getDescriptor(enumField.getType()));
                methodVisitor.visitInsn(176);
            } else {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, snapshotClassBinaryName, methodName, Type.getDescriptor(returnType));
                methodVisitor.visitInsn(176);
            }
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static String _getClassBinaryName(String className) {
        return className.replace('.', '/');
    }

    static {
        try {
            _defineClassMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, "defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
    }
}

