/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.thread.local;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.aop.AopMethodInvocation;
import com.liferay.portal.kernel.aop.ChainableMethodAdvice;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCache;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;

public class ThreadLocalCacheAdvice
extends ChainableMethodAdvice {
    @Override
    public Object createMethodContext(Class<?> targetClass, Method method, Map<Class<? extends Annotation>, Annotation> annotations) {
        return annotations.get(ThreadLocalCachable.class);
    }

    @Override
    public Object invoke(AopMethodInvocation aopMethodInvocation, Object[] arguments) throws Throwable {
        String cacheKey;
        ThreadLocalCachable threadLocalCachable = (ThreadLocalCachable)aopMethodInvocation.getAdviceMethodContext();
        ThreadLocalCache<Object> threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache(threadLocalCachable.scope(), aopMethodInvocation.getMethod());
        Object value = threadLocalCache.get(cacheKey = this._getCacheKey(arguments));
        if (value != null) {
            if (value == nullResult) {
                return null;
            }
            return value;
        }
        Object result = aopMethodInvocation.proceed(arguments);
        if (result == null) {
            threadLocalCache.put(cacheKey, nullResult);
        } else {
            threadLocalCache.put(cacheKey, result);
        }
        return result;
    }

    private String _getCacheKey(Object[] arguments) {
        if (arguments.length == 1) {
            return StringUtil.toHexString(arguments[0]);
        }
        StringBundler sb = new StringBundler(arguments.length * 2 - 1);
        for (int i = 0; i < arguments.length; ++i) {
            sb.append(StringUtil.toHexString(arguments[i]));
            if (i + 1 >= arguments.length) continue;
            sb.append("#");
        }
        return sb.toString();
    }
}

