/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.test.util;

import com.liferay.portal.cache.BasePortalCacheManager;
import com.liferay.portal.cache.configuration.PortalCacheConfiguration;
import com.liferay.portal.cache.configuration.PortalCacheManagerConfiguration;
import com.liferay.portal.cache.test.util.TestPortalCache;
import com.liferay.portal.kernel.cache.PortalCache;
import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TestPortalCacheManager<K extends Serializable, V>
extends BasePortalCacheManager<K, V> {
    private ConcurrentMap<String, TestPortalCache<K, V>> _testPortalCaches;

    public static <K extends Serializable, V> TestPortalCacheManager<K, V> createTestPortalCacheManager(String portalCacheManagerName) {
        TestPortalCacheManager<K, V> testPortalCacheManager = new TestPortalCacheManager<K, V>();
        testPortalCacheManager.setPortalCacheManagerName(portalCacheManagerName);
        testPortalCacheManager.initialize();
        return testPortalCacheManager;
    }

    @Override
    @Deprecated
    public void reconfigurePortalCaches(URL configurationURL) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reconfigurePortalCaches(URL configurationURL, ClassLoader classLoader) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected PortalCache<K, V> createPortalCache(PortalCacheConfiguration portalCacheConfiguration) {
        String portalCacheName = portalCacheConfiguration.getPortalCacheName();
        TestPortalCache portalCache = (TestPortalCache)this._testPortalCaches.get(portalCacheName);
        if (portalCache != null) {
            return portalCache;
        }
        portalCache = new TestPortalCache(this, portalCacheName);
        TestPortalCache previousPortalCache = this._testPortalCaches.putIfAbsent(portalCacheName, portalCache);
        if (previousPortalCache == null) {
            this.aggregatedPortalCacheManagerListener.notifyPortalCacheAdded(portalCacheName);
        } else {
            portalCache = previousPortalCache;
        }
        return portalCache;
    }

    @Override
    protected void doClearAll() {
        for (TestPortalCache testPortalCache : this._testPortalCaches.values()) {
            testPortalCache.removeAll();
        }
    }

    @Override
    protected void doDestroy() {
        for (TestPortalCache testPortalCache : this._testPortalCaches.values()) {
            testPortalCache.removeAll();
        }
        this.aggregatedPortalCacheManagerListener.dispose();
    }

    @Override
    protected void doRemovePortalCache(String portalCacheName) {
        TestPortalCache testPortalCache = (TestPortalCache)this._testPortalCaches.remove(portalCacheName);
        testPortalCache.removeAll();
        this.aggregatedPortalCacheManagerListener.notifyPortalCacheRemoved(portalCacheName);
    }

    @Override
    protected PortalCacheManagerConfiguration getPortalCacheManagerConfiguration() {
        return new PortalCacheManagerConfiguration(null, new PortalCacheConfiguration("default", null, null), null);
    }

    @Override
    protected void initPortalCacheManager() {
        this._testPortalCaches = new ConcurrentHashMap<String, TestPortalCache<K, V>>();
        this.aggregatedPortalCacheManagerListener.init();
    }

    @Override
    protected void removeConfigurableEhcachePortalCacheListeners(PortalCache<K, V> portalCache) {
    }
}

