/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.test.util;

import com.liferay.portal.cache.BasePortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TestPortalCache<K extends Serializable, V>
extends BasePortalCache<K, V> {
    private final ConcurrentMap<K, V> _concurrentMap;
    private final String _portalCacheName;

    public TestPortalCache(PortalCacheManager<K, V> portalCacheManager, String portalCacheName) {
        super(portalCacheManager);
        this._portalCacheName = portalCacheName;
        this._concurrentMap = new ConcurrentHashMap();
    }

    public TestPortalCache(String portalCacheName) {
        super(null);
        this._portalCacheName = portalCacheName;
        this._concurrentMap = new ConcurrentHashMap();
    }

    @Override
    public List<K> getKeys() {
        ArrayList<Serializable> keys = new ArrayList<Serializable>();
        for (Serializable key : this._concurrentMap.keySet()) {
            keys.add(key);
        }
        return keys;
    }

    @Override
    public String getPortalCacheName() {
        return this._portalCacheName;
    }

    @Override
    public void removeAll() {
        this._concurrentMap.clear();
        this.aggregatedPortalCacheListener.notifyRemoveAll(this);
    }

    @Override
    protected V doGet(K key) {
        return this._concurrentMap.get(key);
    }

    @Override
    protected void doPut(K key, V value, int timeToLive) {
        V oldValue = this._concurrentMap.put(key, value);
        if (oldValue != null) {
            this.aggregatedPortalCacheListener.notifyEntryUpdated(this, key, value, timeToLive);
        } else {
            this.aggregatedPortalCacheListener.notifyEntryPut(this, key, value, timeToLive);
        }
    }

    @Override
    protected V doPutIfAbsent(K key, V value, int timeToLive) {
        V oldValue = this._concurrentMap.putIfAbsent(key, value);
        if (oldValue == null) {
            this.aggregatedPortalCacheListener.notifyEntryPut(this, key, value, timeToLive);
        }
        return oldValue;
    }

    @Override
    protected void doRemove(K key) {
        Object value = this._concurrentMap.remove(key);
        this.aggregatedPortalCacheListener.notifyEntryRemoved(this, key, value, 0);
    }

    @Override
    protected boolean doRemove(K key, V value) {
        boolean removed = this._concurrentMap.remove(key, value);
        this.aggregatedPortalCacheListener.notifyEntryRemoved(this, key, value, 0);
        return removed;
    }

    @Override
    protected V doReplace(K key, V value, int timeToLive) {
        V oldValue = this._concurrentMap.replace(key, value);
        if (oldValue != null) {
            this.aggregatedPortalCacheListener.notifyEntryUpdated(this, key, value, timeToLive);
        }
        return oldValue;
    }

    @Override
    protected boolean doReplace(K key, V oldValue, V newValue, int timeToLive) {
        boolean replaced = this._concurrentMap.replace(key, oldValue, newValue);
        if (replaced) {
            this.aggregatedPortalCacheListener.notifyEntryUpdated(this, key, newValue, timeToLive);
        }
        return replaced;
    }
}

