/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.key;

import com.liferay.petra.nio.CharsetEncoderUtil;
import com.liferay.portal.cache.key.BaseCacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigestCacheKeyGenerator
extends BaseCacheKeyGenerator {
    private static final boolean _CALLING_GET_CACHE_KEY_THREAD_SAFE = false;
    private final CharsetEncoder _charsetEncoder;
    private final MessageDigest _messageDigest;

    public MessageDigestCacheKeyGenerator(String algorithm) throws NoSuchAlgorithmException {
        this(algorithm, "UTF-8");
    }

    public MessageDigestCacheKeyGenerator(String algorithm, String charsetName) throws NoSuchAlgorithmException {
        this._messageDigest = MessageDigest.getInstance(algorithm);
        this._charsetEncoder = CharsetEncoderUtil.getCharsetEncoder(charsetName);
    }

    @Override
    public CacheKeyGenerator clone() {
        Charset charset = this._charsetEncoder.charset();
        try {
            return new MessageDigestCacheKeyGenerator(this._messageDigest.getAlgorithm(), charset.name());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
    }

    @Override
    public Serializable getCacheKey(String key) {
        try {
            this._messageDigest.update(this._charsetEncoder.encode(CharBuffer.wrap(key)));
            return StringUtil.bytesToHexString(this._messageDigest.digest());
        }
        catch (CharacterCodingException cce) {
            throw new SystemException(cce);
        }
    }

    @Override
    public Serializable getCacheKey(String[] keys) {
        return this.getCacheKey(keys, keys.length);
    }

    @Override
    public Serializable getCacheKey(StringBundler sb) {
        return this.getCacheKey(sb.getStrings(), sb.index());
    }

    @Override
    public boolean isCallingGetCacheKeyThreadSafe() {
        return false;
    }

    protected Serializable getCacheKey(String[] keys, int length) {
        try {
            for (int i = 0; i < length; ++i) {
                this._messageDigest.update(this._charsetEncoder.encode(CharBuffer.wrap(keys[i])));
            }
            return StringUtil.bytesToHexString(this._messageDigest.digest());
        }
        catch (CharacterCodingException cce) {
            throw new SystemException(cce);
        }
    }
}

