/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.key;

import com.liferay.portal.cache.key.BaseCacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;

public class HashCodeHexStringCacheKeyGenerator
extends BaseCacheKeyGenerator {
    @Override
    public CacheKeyGenerator clone() {
        return new HashCodeHexStringCacheKeyGenerator();
    }

    public String getCacheKey(String key) {
        return StringUtil.toHexString(key.hashCode());
    }

    public String getCacheKey(String[] keys) {
        int hashCode = 0;
        int weight = 1;
        for (int i = keys.length - 1; i >= 0; --i) {
            String s = keys[i];
            hashCode = s.hashCode() * weight + hashCode;
            for (int j = s.length(); j > 0; --j) {
                weight *= 31;
            }
        }
        return StringUtil.toHexString(hashCode);
    }

    public String getCacheKey(StringBundler sb) {
        return this.getCacheKey(sb.getStrings());
    }
}

