/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.io;

import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class SerializableObjectWrapper
implements Serializable {
    private static final Log _log = LogFactoryUtil.getLog(SerializableObjectWrapper.class);
    private Serializable _serializable;

    public static <T> T unwrap(Object object) {
        if (!(object instanceof SerializableObjectWrapper)) {
            return (T)object;
        }
        SerializableObjectWrapper serializableWrapper = (SerializableObjectWrapper)object;
        return (T)serializableWrapper._serializable;
    }

    public SerializableObjectWrapper(Serializable serializable) {
        this._serializable = serializable;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SerializableObjectWrapper)) {
            return false;
        }
        SerializableObjectWrapper serializableWrapper = (SerializableObjectWrapper)object;
        return this._serializable.equals(serializableWrapper._serializable);
    }

    public int hashCode() {
        return this._serializable.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        byte[] data = new byte[objectInputStream.readInt()];
        objectInputStream.readFully(data);
        Deserializer deserializer = new Deserializer(ByteBuffer.wrap(data));
        try {
            this._serializable = deserializer.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            _log.error("Unable to deserialize object", cnfe);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Serializer serializer = new Serializer();
        serializer.writeObject(this._serializable);
        ByteBuffer byteBuffer = serializer.toByteBuffer();
        objectOutputStream.writeInt(byteBuffer.remaining());
        objectOutputStream.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
    }
}

