/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache;

import com.liferay.portal.cache.PortalCacheWrapper;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.concurrent.CompeteLatch;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BlockingPortalCache<K extends Serializable, V>
extends PortalCacheWrapper<K, V> {
    private static final ThreadLocal<CompeteLatch> _competeLatch = new ThreadLocal();
    private final ConcurrentMap<K, CompeteLatch> _competeLatchMap = new ConcurrentHashMap<K, CompeteLatch>();

    public BlockingPortalCache(PortalCache<K, V> portalCache) {
        super(portalCache);
    }

    @Override
    public V get(K key) {
        CompeteLatch newCompeteLatch;
        CompeteLatch currentCompeteLatch;
        Object value = this.portalCache.get(key);
        if (value != null) {
            return value;
        }
        CompeteLatch lastCompeteLatch = _competeLatch.get();
        if (lastCompeteLatch != null) {
            lastCompeteLatch.done();
            _competeLatch.set(null);
        }
        if ((currentCompeteLatch = (CompeteLatch)this._competeLatchMap.get(key)) == null && (currentCompeteLatch = this._competeLatchMap.putIfAbsent(key, newCompeteLatch = new CompeteLatch())) == null) {
            currentCompeteLatch = newCompeteLatch;
        }
        _competeLatch.set(currentCompeteLatch);
        if (!currentCompeteLatch.compete()) {
            try {
                currentCompeteLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            _competeLatch.set(null);
            value = this.portalCache.get(key);
        }
        return value;
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, 0);
    }

    @Override
    public void put(K key, V value, int timeToLive) {
        this.portalCache.put(key, value, timeToLive);
        CompeteLatch competeLatch = _competeLatch.get();
        if (competeLatch != null) {
            competeLatch.done();
            _competeLatch.set(null);
        }
        this._competeLatchMap.remove(key);
    }

    @Override
    public void remove(K key) {
        this.portalCache.remove(key);
        CompeteLatch competeLatch = (CompeteLatch)this._competeLatchMap.remove(key);
        if (competeLatch != null) {
            competeLatch.done();
        }
    }

    @Override
    public void removeAll() {
        this.portalCache.removeAll();
        Collection competeLatches = this._competeLatchMap.values();
        Iterator iterator = competeLatches.iterator();
        while (iterator.hasNext()) {
            CompeteLatch competeLatch = (CompeteLatch)iterator.next();
            iterator.remove();
            competeLatch.done();
        }
    }
}

