/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache;

import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class AggregatedPortalCacheManagerListener
implements PortalCacheManagerListener {
    private final Set<PortalCacheManagerListener> _portalCacheManagerListeners = new CopyOnWriteArraySet<PortalCacheManagerListener>();

    public boolean addPortalCacheListener(PortalCacheManagerListener portalCacheManagerListener) {
        if (portalCacheManagerListener == null) {
            return false;
        }
        return this._portalCacheManagerListeners.add(portalCacheManagerListener);
    }

    public void clearAll() {
        this._portalCacheManagerListeners.clear();
    }

    @Override
    public void dispose() throws PortalCacheException {
        for (PortalCacheManagerListener portalCacheManagerListener : this._portalCacheManagerListeners) {
            portalCacheManagerListener.dispose();
        }
    }

    public Set<PortalCacheManagerListener> getPortalCacheManagerListeners() {
        return Collections.unmodifiableSet(this._portalCacheManagerListeners);
    }

    @Override
    public void init() throws PortalCacheException {
        for (PortalCacheManagerListener portalCacheManagerListener : this._portalCacheManagerListeners) {
            portalCacheManagerListener.init();
        }
    }

    @Override
    public void notifyPortalCacheAdded(String portalCacheName) {
        for (PortalCacheManagerListener portalCacheManagerListener : this._portalCacheManagerListeners) {
            portalCacheManagerListener.notifyPortalCacheAdded(portalCacheName);
        }
    }

    @Override
    public void notifyPortalCacheRemoved(String portalCacheName) {
        for (PortalCacheManagerListener portalCacheManagerListener : this._portalCacheManagerListeners) {
            portalCacheManagerListener.notifyPortalCacheRemoved(portalCacheName);
        }
    }

    public boolean removePortalCacheListener(PortalCacheManagerListener portalCacheManagerListener) {
        if (portalCacheManagerListener == null) {
            return false;
        }
        return this._portalCacheManagerListeners.remove(portalCacheManagerListener);
    }
}

