/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache;

import com.liferay.portal.cache.PortalCacheReplicator;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCacheListenerScope;
import com.liferay.portal.kernel.cache.SkipReplicationThreadLocal;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AggregatedPortalCacheListener<K extends Serializable, V>
implements PortalCacheListener<K, V> {
    private final ConcurrentMap<PortalCacheListener<K, V>, PortalCacheListenerScope> _portalCacheListeners = new ConcurrentHashMap<PortalCacheListener<K, V>, PortalCacheListenerScope>();

    public void addPortalCacheListener(PortalCacheListener<K, V> portalCacheListener) {
        this.addPortalCacheListener(portalCacheListener, PortalCacheListenerScope.ALL);
    }

    public void addPortalCacheListener(PortalCacheListener<K, V> portalCacheListener, PortalCacheListenerScope portalCacheListenerScope) {
        this._portalCacheListeners.putIfAbsent(portalCacheListener, portalCacheListenerScope);
    }

    public void clearAll() {
        this.dispose();
        this._portalCacheListeners.clear();
    }

    @Override
    public void dispose() {
        for (PortalCacheListener portalCacheListener : this._portalCacheListeners.keySet()) {
            portalCacheListener.dispose();
        }
    }

    public Map<PortalCacheListener<K, V>, PortalCacheListenerScope> getPortalCacheListeners() {
        return Collections.unmodifiableMap(this._portalCacheListeners);
    }

    public boolean isEmpty() {
        return this._portalCacheListeners.isEmpty();
    }

    @Override
    public void notifyEntryEvicted(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        for (Map.Entry entry : this._portalCacheListeners.entrySet()) {
            PortalCacheListener portalCacheListener = (PortalCacheListener)entry.getKey();
            if (!this._shouldDeliver(portalCacheListener, (PortalCacheListenerScope)((Object)entry.getValue()))) continue;
            portalCacheListener.notifyEntryEvicted(portalCache, key, value, timeToLive);
        }
    }

    @Override
    public void notifyEntryExpired(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        for (Map.Entry entry : this._portalCacheListeners.entrySet()) {
            PortalCacheListener portalCacheListener = (PortalCacheListener)entry.getKey();
            if (!this._shouldDeliver(portalCacheListener, (PortalCacheListenerScope)((Object)entry.getValue()))) continue;
            portalCacheListener.notifyEntryExpired(portalCache, key, value, timeToLive);
        }
    }

    @Override
    public void notifyEntryPut(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        for (Map.Entry entry : this._portalCacheListeners.entrySet()) {
            PortalCacheListener portalCacheListener = (PortalCacheListener)entry.getKey();
            if (!this._shouldDeliver(portalCacheListener, (PortalCacheListenerScope)((Object)entry.getValue()))) continue;
            portalCacheListener.notifyEntryPut(portalCache, key, value, timeToLive);
        }
    }

    @Override
    public void notifyEntryRemoved(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        for (Map.Entry entry : this._portalCacheListeners.entrySet()) {
            PortalCacheListener portalCacheListener = (PortalCacheListener)entry.getKey();
            if (!this._shouldDeliver(portalCacheListener, (PortalCacheListenerScope)((Object)entry.getValue()))) continue;
            portalCacheListener.notifyEntryRemoved(portalCache, key, value, timeToLive);
        }
    }

    @Override
    public void notifyEntryUpdated(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        for (Map.Entry entry : this._portalCacheListeners.entrySet()) {
            PortalCacheListener portalCacheListener = (PortalCacheListener)entry.getKey();
            if (!this._shouldDeliver(portalCacheListener, (PortalCacheListenerScope)((Object)entry.getValue()))) continue;
            portalCacheListener.notifyEntryUpdated(portalCache, key, value, timeToLive);
        }
    }

    @Override
    public void notifyRemoveAll(PortalCache<K, V> portalCache) throws PortalCacheException {
        for (Map.Entry entry : this._portalCacheListeners.entrySet()) {
            PortalCacheListener portalCacheListener = (PortalCacheListener)entry.getKey();
            if (!this._shouldDeliver(portalCacheListener, (PortalCacheListenerScope)((Object)entry.getValue()))) continue;
            portalCacheListener.notifyRemoveAll(portalCache);
        }
    }

    public void removePortalCacheListener(PortalCacheListener<K, V> portalCacheListener) {
        portalCacheListener.dispose();
        this._portalCacheListeners.remove(portalCacheListener);
    }

    private boolean _shouldDeliver(PortalCacheListener<K, V> portalCacheListener, PortalCacheListenerScope portalCacheListenerScope) {
        if (SkipReplicationThreadLocal.isEnabled()) {
            if (portalCacheListener instanceof PortalCacheReplicator) {
                return false;
            }
            return portalCacheListenerScope.equals((Object)PortalCacheListenerScope.ALL) || portalCacheListenerScope.equals((Object)PortalCacheListenerScope.REMOTE);
        }
        return portalCacheListenerScope.equals((Object)PortalCacheListenerScope.ALL) || portalCacheListenerScope.equals((Object)PortalCacheListenerScope.LOCAL);
    }
}

