/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.bean;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.bean.VelocityBeanHandler;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public class BeanLocatorImpl
implements BeanLocator {
    public static final String VELOCITY_SUFFIX = ".velocity";
    private static final Log _log = LogFactoryUtil.getLog(BeanLocatorImpl.class);
    private ApplicationContext _applicationContext;
    private final ClassLoader _classLoader;
    private final Map<String, Object> _velocityBeans = new ConcurrentHashMap<String, Object>();

    public BeanLocatorImpl(ClassLoader classLoader, ApplicationContext applicationContext) {
        this._classLoader = classLoader;
        this._applicationContext = applicationContext;
    }

    @Override
    public void destroy() {
        if (this._applicationContext instanceof AbstractApplicationContext) {
            AbstractApplicationContext abstractApplicationContext = (AbstractApplicationContext)this._applicationContext;
            abstractApplicationContext.destroy();
        }
        this._applicationContext = null;
    }

    public ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    @Override
    public String[] getNames() {
        return this._applicationContext.getBeanDefinitionNames();
    }

    @Override
    public Class<?> getType(String name) {
        try {
            return this._applicationContext.getType(name);
        }
        catch (Exception e) {
            throw new BeanLocatorException(e);
        }
    }

    @Override
    public <T> Map<String, T> locate(Class<T> clazz) throws BeanLocatorException {
        try {
            return this.doLocate(clazz);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new BeanLocatorException(e);
        }
    }

    @Override
    public Object locate(String name) throws BeanLocatorException {
        try {
            return this.doLocate(name);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new BeanLocatorException(e);
        }
    }

    @Deprecated
    public void setPACLServletContextName(String paclServletContextName) {
    }

    protected <T> Map<String, T> doLocate(Class<T> clazz) throws Exception {
        return this._applicationContext.getBeansOfType(clazz);
    }

    protected Object doLocate(String name) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug("Locating " + name);
        }
        if (name.endsWith(VELOCITY_SUFFIX)) {
            Object velocityBean = this._velocityBeans.get(name);
            if (velocityBean == null) {
                String originalName = name.substring(0, name.length() - VELOCITY_SUFFIX.length());
                Object curBean = this._applicationContext.getBean(originalName);
                velocityBean = ProxyUtil.newProxyInstance(this._classLoader, ReflectionUtil.getInterfaces(curBean, this._classLoader), new VelocityBeanHandler(curBean, this._classLoader));
                this._velocityBeans.put(name, velocityBean);
            }
            return velocityBean;
        }
        return this._applicationContext.getBean(name);
    }

    @Deprecated
    public static interface PACL {
        public Object getBean(Object var1, ClassLoader var2);
    }
}

