/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.aspectj;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aspectj.URLWeavingAdapter;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Arrays;
import org.aspectj.bridge.AbortException;

public class WeavingClassLoader
extends URLClassLoader {
    private static final Log _log = LogFactoryUtil.getLog(WeavingClassLoader.class);
    private final File _dumpDir;
    private final URLWeavingAdapter _urlWeavingAdapter;

    public WeavingClassLoader(URL[] urls, Class<?>[] aspectClasses, File dumpDir) {
        super(urls, (ClassLoader)null);
        this._dumpDir = dumpDir;
        this._urlWeavingAdapter = new URLWeavingAdapter(urls, aspectClasses);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String resourcePath = name.replace('.', '/') + ".class";
        InputStream inputStream = this.getResourceAsStream(resourcePath);
        byte[] data = null;
        try {
            byte[] oldData;
            block24: {
                if (inputStream == null) {
                    data = this._urlWeavingAdapter.removeGeneratedClassDate(name);
                } else {
                    UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                    StreamUtil.transfer(inputStream, unsyncByteArrayOutputStream);
                    data = unsyncByteArrayOutputStream.toByteArray();
                }
                if (data == null) {
                    throw new ClassNotFoundException(name);
                }
                oldData = data;
                try {
                    data = this._urlWeavingAdapter.weaveClass(name, data, false);
                }
                catch (AbortException ae) {
                    if (!_log.isWarnEnabled()) break block24;
                    _log.warn("Abort weaving class " + name, ae);
                }
            }
            if (Arrays.equals(oldData, data)) {
                return this._generateClass(name, data);
            }
            if (this._dumpDir != null) {
                File dumpFile = new File(this._dumpDir, resourcePath);
                File dumpDir = dumpFile.getParentFile();
                dumpDir.mkdirs();
                try (FileOutputStream fileOutputStream = new FileOutputStream(dumpFile);){
                    fileOutputStream.write(data);
                }
                if (_log.isInfoEnabled()) {
                    _log.info(StringBundler.concat("Woven class ", name, " result in ", dumpFile.getCanonicalPath()));
                }
            } else if (_log.isInfoEnabled()) {
                _log.info("Woven class " + name);
            }
            return this._generateClass(name, data);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(name, ioe);
        }
    }

    private Class<?> _generateClass(String name, byte[] data) {
        Package pkg;
        Class<?> clazz = this.defineClass(name, data, 0, data.length, (ProtectionDomain)null);
        String packageName = null;
        int index = name.lastIndexOf(46);
        if (index != -1) {
            packageName = name.substring(0, index);
        }
        if (packageName != null && (pkg = this.getPackage(packageName)) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        return clazz;
    }
}

