/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.asm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.MethodNode;

public class MethodNodeGenerator
extends GeneratorAdapter {
    private final MethodNode _methodNode;

    public MethodNodeGenerator(Method method) {
        this(MethodNodeGenerator._createMethodNode(method));
    }

    public MethodNodeGenerator(MethodNode methodNode) {
        super(327680, (MethodVisitor)methodNode, methodNode.access, methodNode.name, methodNode.desc);
        this._methodNode = methodNode;
    }

    public MethodNode getMethodNode() {
        return this._methodNode;
    }

    public void invokeInterface(String owner, Method method) {
        super.visitMethodInsn(185, owner, method.getName(), Type.getMethodDescriptor(method), true);
    }

    public void invokeInterface(String owner, String name, Type returnType, Type ... argumentTypes) {
        super.visitMethodInsn(185, owner, name, Type.getMethodDescriptor(returnType, argumentTypes), true);
    }

    public void invokeSpecial(String owner, Method method) {
        super.visitMethodInsn(183, owner, method.getName(), Type.getMethodDescriptor(method), false);
    }

    public void invokeSpecial(String owner, String name, Type returnType, Type ... argumentTypes) {
        super.visitMethodInsn(183, owner, name, Type.getMethodDescriptor(returnType, argumentTypes), false);
    }

    public void invokeStatic(String owner, Method method) {
        super.visitMethodInsn(184, owner, method.getName(), Type.getMethodDescriptor(method), false);
    }

    public void invokeStatic(String owner, String name, Type returnType, Type ... argumentTypes) {
        super.visitMethodInsn(184, owner, name, Type.getMethodDescriptor(returnType, argumentTypes), false);
    }

    public void invokeVirtual(String owner, Method method) {
        super.visitMethodInsn(182, owner, method.getName(), Type.getMethodDescriptor(method), false);
    }

    public void invokeVirtual(String owner, String name, Type returnType, Type ... argumentTypes) {
        super.visitMethodInsn(182, owner, name, Type.getMethodDescriptor(returnType, argumentTypes), false);
    }

    public void visitMethodInsn(int opcode, String owner, String name, Type returnType, Type ... argumentTypes) {
        super.visitMethodInsn(opcode, owner, name, Type.getMethodDescriptor(returnType, argumentTypes), false);
    }

    private static MethodNode _createMethodNode(Method method) {
        MethodNode methodNode = new MethodNode();
        methodNode.access = method.getModifiers() & 0xFFFFFBFF;
        methodNode.name = method.getName();
        methodNode.desc = Type.getMethodDescriptor(method);
        ArrayList<String> exceptions = new ArrayList<String>();
        for (Class<?> exceptionClass : method.getExceptionTypes()) {
            exceptions.add(Type.getInternalName(exceptionClass));
        }
        methodNode.exceptions = exceptions;
        return methodNode;
    }
}

