/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.TicketLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VerifyEmailAddressAction
implements Action {
    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String cmd = ParamUtil.getString(httpServletRequest, "cmd");
        if (Validator.isNull(cmd)) {
            return actionMapping.getActionForward("portal.verify_email_address");
        }
        if (themeDisplay.isSignedIn() && cmd.equals("send")) {
            this.sendEmailAddressVerification(httpServletRequest, httpServletResponse, themeDisplay);
            return actionMapping.getActionForward("portal.verify_email_address");
        }
        try {
            this.verifyEmailAddress(httpServletRequest, httpServletResponse, themeDisplay);
            if (!themeDisplay.isSignedIn()) {
                LiferayPortletURL portletURL = PortletURLFactoryUtil.create(httpServletRequest, "com_liferay_login_web_portlet_LoginPortlet", "RENDER_PHASE");
                httpServletResponse.sendRedirect(portletURL.toString());
                return null;
            }
            return actionMapping.getActionForward("/common/referer_jsp.jsp");
        }
        catch (Exception e) {
            if (e instanceof PortalException || e instanceof SystemException) {
                SessionErrors.add(httpServletRequest, e.getClass());
                return actionMapping.getActionForward("portal.verify_email_address");
            }
            PortalUtil.sendError(e, httpServletRequest, httpServletResponse);
            return null;
        }
    }

    protected void sendEmailAddressVerification(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ThemeDisplay themeDisplay) throws Exception {
        User user = themeDisplay.getUser();
        ServiceContext serviceContext = ServiceContextFactory.getInstance(httpServletRequest);
        List<Ticket> tickets = TicketLocalServiceUtil.getTickets(themeDisplay.getCompanyId(), User.class.getName(), user.getUserId(), 1);
        if (ListUtil.isEmpty(tickets)) {
            UserLocalServiceUtil.sendEmailAddressVerification(user, user.getEmailAddress(), serviceContext);
        } else {
            Ticket ticket = tickets.get(0);
            UserLocalServiceUtil.sendEmailAddressVerification(user, ticket.getExtraInfo(), serviceContext);
        }
    }

    protected void verifyEmailAddress(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ThemeDisplay themeDisplay) throws Exception {
        AuthTokenUtil.checkCSRFToken(httpServletRequest, VerifyEmailAddressAction.class.getName());
        String ticketKey = ParamUtil.getString(httpServletRequest, "ticketKey");
        UserLocalServiceUtil.verifyEmailAddress(ticketKey);
    }
}

