/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.UserReminderQueryException;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.UserServiceUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UpdateReminderQueryAction
implements Action {
    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String cmd = ParamUtil.getString(httpServletRequest, "cmd");
        if (Validator.isNull(cmd)) {
            return actionMapping.getActionForward("portal.update_reminder_query");
        }
        try {
            this.updateReminderQuery(httpServletRequest, httpServletResponse);
            return actionMapping.getActionForward("/common/referer_jsp.jsp");
        }
        catch (Exception e) {
            if (e instanceof UserReminderQueryException) {
                SessionErrors.add(httpServletRequest, e.getClass());
                return actionMapping.getActionForward("portal.update_reminder_query");
            }
            if (e instanceof NoSuchUserException || e instanceof PrincipalException) {
                SessionErrors.add(httpServletRequest, e.getClass());
                return actionMapping.getActionForward("portal.error");
            }
            PortalUtil.sendError(e, httpServletRequest, httpServletResponse);
            return null;
        }
    }

    protected void updateReminderQuery(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        AuthTokenUtil.checkCSRFToken(httpServletRequest, UpdateReminderQueryAction.class.getName());
        long userId = PortalUtil.getUserId(httpServletRequest);
        String question = ParamUtil.getString(httpServletRequest, "reminderQueryQuestion");
        String answer = ParamUtil.getString(httpServletRequest, "reminderQueryAnswer");
        if (question.equals("write-my-own-question")) {
            question = ParamUtil.getString(httpServletRequest, "reminderQueryCustomQuestion");
        }
        UserServiceUtil.updateReminderQuery(userId, question, answer);
    }
}

