/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.UserLockoutException;
import com.liferay.portal.kernel.exception.UserPasswordException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManagerUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.TicketLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pwd.PwdToolkitUtilThreadLocal;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class UpdatePasswordAction
implements Action {
    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Ticket ticket = this.getTicket(httpServletRequest);
        if (ticket != null && StringUtil.equals(httpServletRequest.getMethod(), "GET")) {
            this.resendAsPost(httpServletRequest, httpServletResponse);
            return null;
        }
        httpServletRequest.setAttribute("TICKET", (Object)ticket);
        String cmd = ParamUtil.getString(httpServletRequest, "cmd");
        if (Validator.isNull(cmd)) {
            if (ticket != null) {
                User user = UserLocalServiceUtil.getUser(ticket.getClassPK());
                try {
                    UserLocalServiceUtil.checkLockout(user);
                    UserLocalServiceUtil.updatePasswordReset(user.getUserId(), true);
                }
                catch (UserLockoutException ule) {
                    SessionErrors.add(httpServletRequest, ule.getClass(), (Object)ule);
                }
            }
            return actionMapping.getActionForward("portal.update_password");
        }
        try {
            this.updatePassword(httpServletRequest, httpServletResponse, themeDisplay, ticket);
            String redirect = ParamUtil.getString(httpServletRequest, "referer");
            if (Validator.isNotNull(redirect)) {
                redirect = PortalUtil.escapeRedirect(redirect);
            }
            if (Validator.isNull(redirect)) {
                redirect = themeDisplay.getPathMain();
            }
            httpServletResponse.sendRedirect(redirect);
            return null;
        }
        catch (Exception e) {
            if (e instanceof UserPasswordException) {
                SessionErrors.add(httpServletRequest, e.getClass(), (Object)e);
                return actionMapping.getActionForward("portal.update_password");
            }
            if (e instanceof NoSuchUserException || e instanceof PrincipalException) {
                SessionErrors.add(httpServletRequest, e.getClass());
                return actionMapping.getActionForward("portal.error");
            }
            PortalUtil.sendError(e, httpServletRequest, httpServletResponse);
            return null;
        }
    }

    protected Ticket getTicket(HttpServletRequest httpServletRequest) {
        String ticketKey = ParamUtil.getString(httpServletRequest, "ticketKey");
        if (Validator.isNull(ticketKey)) {
            return null;
        }
        try {
            Ticket ticket = TicketLocalServiceUtil.fetchTicket(ticketKey);
            if (ticket == null || ticket.getType() != 3) {
                return null;
            }
            if (!ticket.isExpired()) {
                return ticket;
            }
            TicketLocalServiceUtil.deleteTicket(ticket);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected boolean isValidatePassword(HttpServletRequest httpServletRequest) {
        HttpSession session = httpServletRequest.getSession();
        Boolean setupWizardPasswordUpdated = (Boolean)session.getAttribute("SETUP_WIZARD_PASSWORD_UPDATED");
        return setupWizardPasswordUpdated == null || setupWizardPasswordUpdated == false;
    }

    protected void resendAsPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        httpServletResponse.setHeader("Expires", "0");
        httpServletResponse.setHeader("Pragma", "no-cache");
        PrintWriter printWriter = httpServletResponse.getWriter();
        Map parameterMap = httpServletRequest.getParameterMap();
        StringBundler sb = new StringBundler(7 + parameterMap.size() * 5);
        sb.append("<html><body onload=\"document.fm.submit();\">");
        sb.append("<form action=\"");
        sb.append(PortalUtil.getPortalURL(httpServletRequest));
        sb.append("/c/portal/update_password\" method=\"post\" name=\"fm\">");
        for (String name : parameterMap.keySet()) {
            String value = ParamUtil.getString(httpServletRequest, name);
            sb.append("<input name=\"");
            sb.append(HtmlUtil.escapeAttribute(name));
            sb.append("\" type=\"hidden\" value=\"");
            sb.append(HtmlUtil.escapeAttribute(value));
            sb.append("\"/>");
        }
        sb.append("<noscript>");
        sb.append("<input type=\"submit\" value=\"Please continue here...\"/>");
        sb.append("</noscript></form></body></html>");
        printWriter.write(sb.toString());
        printWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePassword(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ThemeDisplay themeDisplay, Ticket ticket) throws Exception {
        AuthTokenUtil.checkCSRFToken(httpServletRequest, UpdatePasswordAction.class.getName());
        long userId = 0L;
        userId = ticket != null ? ticket.getClassPK() : themeDisplay.getUserId();
        String password1 = httpServletRequest.getParameter("password1");
        String password2 = httpServletRequest.getParameter("password2");
        boolean passwordReset = false;
        boolean previousValidate = PwdToolkitUtilThreadLocal.isValidate();
        try {
            boolean currentValidate = this.isValidatePassword(httpServletRequest);
            PwdToolkitUtilThreadLocal.setValidate(currentValidate);
            UserLocalServiceUtil.updatePassword(userId, password1, password2, passwordReset);
        }
        finally {
            PwdToolkitUtilThreadLocal.setValidate(previousValidate);
        }
        if (ticket != null) {
            TicketLocalServiceUtil.deleteTicket(ticket);
            UserLocalServiceUtil.updatePasswordReset(userId, false);
        }
        User user = UserLocalServiceUtil.getUser(userId);
        Company company = CompanyLocalServiceUtil.getCompanyById(user.getCompanyId());
        String login = null;
        String authType = company.getAuthType();
        if (authType.equals("emailAddress")) {
            login = user.getEmailAddress();
        } else if (authType.equals("screenName")) {
            login = user.getScreenName();
        } else if (authType.equals("userId")) {
            login = String.valueOf(userId);
        }
        AuthenticatedSessionManagerUtil.login(httpServletRequest, httpServletResponse, login, password1, false, null);
    }
}

