/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.license.util.LicenseManagerUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.util.LicenseUtil;
import com.liferay.portlet.admin.util.OmniadminUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UpdateLicenseAction
implements Action {
    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (this._isValidRequest(httpServletRequest)) {
            String cmd = ParamUtil.getString(httpServletRequest, "cmd");
            String clusterNodeId = ParamUtil.getString(httpServletRequest, "clusterNodeId");
            if (cmd.equals("licenseProperties")) {
                String licenseProperties = this._getLicenseProperties(clusterNodeId);
                httpServletResponse.setContentType("application/json");
                ServletResponseUtil.write(httpServletResponse, licenseProperties);
                return null;
            }
            if (cmd.equals("serverInfo")) {
                String serverInfo = this._getServerInfo(clusterNodeId);
                httpServletResponse.setContentType("application/json");
                ServletResponseUtil.write(httpServletResponse, serverInfo);
                return null;
            }
            return actionMapping.getActionForward("portal.license");
        }
        httpServletResponse.sendRedirect(PortalUtil.getPathContext() + "/c/portal/layout");
        return null;
    }

    private String _getLicenseProperties(String clusterNodeId) {
        List<Map<String, String>> licenseProperties = LicenseManagerUtil.getClusterLicenseProperties(clusterNodeId);
        if (licenseProperties == null) {
            return "";
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (Map<String, String> propertiesMap : licenseProperties) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
                jsonObject.put(entry.getKey(), entry.getValue());
            }
            jsonArray.put(jsonObject);
        }
        return jsonArray.toString();
    }

    private String _getServerInfo(String clusterNodeId) throws Exception {
        Map<String, String> serverInfo = LicenseUtil.getClusterServerInfo(clusterNodeId);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (serverInfo != null) {
            for (Map.Entry<String, String> entry : serverInfo.entrySet()) {
                jsonObject.put(entry.getKey(), entry.getValue());
            }
        }
        return jsonObject.toString();
    }

    private boolean _isOmniAdmin(HttpServletRequest httpServletRequest) {
        User user = null;
        try {
            user = PortalUtil.getUser(httpServletRequest);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return user != null && OmniadminUtil.isOmniadmin(user);
    }

    private boolean _isValidRequest(HttpServletRequest httpServletRequest) {
        if (this._isOmniAdmin(httpServletRequest)) {
            LicenseUtil.registerOrder(httpServletRequest);
            return true;
        }
        return false;
    }
}

