/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.action.RenderPortletAction;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.AddPortletProvider;
import com.liferay.portal.kernel.portlet.PortletJSONUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.NamespaceServletRequest;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.JSONAction;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UpdateLayoutAction
extends JSONAction {
    private static final ServiceTrackerMap<String, AddPortletProvider> _serviceTrackerMap = ServiceTrackerCollections.openSingleValueMap(AddPortletProvider.class, "model.class.name");

    @Override
    public String getJSON(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long userId = themeDisplay.getUserId();
        Layout layout = themeDisplay.getLayout();
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        String cmd = ParamUtil.getString(httpServletRequest, "cmd");
        String portletId = ParamUtil.getString(httpServletRequest, "p_p_id");
        boolean updateLayout = true;
        if (cmd.equals("add")) {
            String columnId = ParamUtil.getString(httpServletRequest, "p_p_col_id", null);
            int columnPos = ParamUtil.getInteger(httpServletRequest, "p_p_col_pos", -1);
            portletId = layoutTypePortlet.addPortletId(userId, portletId, columnId, columnPos);
            this.storeAddContentPortletPreferences(httpServletRequest, layout, portletId, themeDisplay);
            if (layoutTypePortlet.isCustomizable() && layoutTypePortlet.isCustomizedView() && !layoutTypePortlet.isColumnDisabled(columnId)) {
                updateLayout = false;
            }
        } else if (cmd.equals("delete")) {
            if (layoutTypePortlet.hasPortletId(portletId)) {
                layoutTypePortlet.removePortletId(userId, portletId);
                if (layoutTypePortlet.isCustomizable() && layoutTypePortlet.isCustomizedView()) {
                    updateLayout = false;
                }
            }
        } else if (cmd.equals("minimize")) {
            boolean restore = ParamUtil.getBoolean(httpServletRequest, "p_p_restore");
            if (restore) {
                layoutTypePortlet.removeStateMinPortletId(portletId);
            } else {
                layoutTypePortlet.addStateMinPortletId(portletId);
            }
            updateLayout = false;
        } else if (cmd.equals("move")) {
            String columnId = ParamUtil.getString(httpServletRequest, "p_p_col_id");
            int columnPos = ParamUtil.getInteger(httpServletRequest, "p_p_col_pos");
            layoutTypePortlet.movePortletId(userId, portletId, columnId, columnPos);
            if (layoutTypePortlet.isCustomizable() && layoutTypePortlet.isCustomizedView() && !layoutTypePortlet.isColumnDisabled(columnId)) {
                updateLayout = false;
            }
        } else if (cmd.equals("redo_layout_revision")) {
            long layoutRevisionId = ParamUtil.getLong(httpServletRequest, "layoutRevisionId");
            long layoutSetBranchId = ParamUtil.getLong(httpServletRequest, "layoutSetBranchId");
            ServiceContext serviceContext = ServiceContextFactory.getInstance(httpServletRequest);
            LayoutRevisionLocalServiceUtil.updateStatus(userId, layoutRevisionId, 2, serviceContext);
            StagingUtil.setRecentLayoutRevisionId(httpServletRequest, layoutSetBranchId, layout.getPlid(), layoutRevisionId);
            updateLayout = false;
        } else if (cmd.equals("select_layout_revision")) {
            long layoutRevisionId = ParamUtil.getLong(httpServletRequest, "layoutRevisionId");
            long layoutSetBranchId = ParamUtil.getLong(httpServletRequest, "layoutSetBranchId");
            StagingUtil.setRecentLayoutRevisionId(httpServletRequest, layoutSetBranchId, layout.getPlid(), layoutRevisionId);
            updateLayout = false;
        } else if (cmd.equals("update_type_settings")) {
            UnicodeProperties layoutTypeSettingsProperties = layout.getTypeSettingsProperties();
            UnicodeProperties formTypeSettingsProperties = PropertiesParamUtil.getProperties(httpServletRequest, "TypeSettingsProperties--");
            layoutTypeSettingsProperties.putAll(formTypeSettingsProperties);
        } else if (cmd.equals("undo_layout_revision")) {
            long layoutRevisionId = ParamUtil.getLong(httpServletRequest, "layoutRevisionId");
            long layoutSetBranchId = ParamUtil.getLong(httpServletRequest, "layoutSetBranchId");
            ServiceContext serviceContext = ServiceContextFactory.getInstance(httpServletRequest);
            LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.updateStatus(userId, layoutRevisionId, 5, serviceContext);
            StagingUtil.setRecentLayoutRevisionId(httpServletRequest, layoutSetBranchId, layout.getPlid(), layoutRevision.getParentLayoutRevisionId());
            updateLayout = false;
        }
        if (updateLayout) {
            layoutTypePortlet.resetModes();
            layoutTypePortlet.resetStates();
            layout = LayoutServiceUtil.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
        } else {
            LayoutClone layoutClone = LayoutCloneFactory.getInstance();
            if (layoutClone != null) {
                layoutClone.update(httpServletRequest, layout.getPlid(), layout.getTypeSettings());
            }
        }
        if (cmd.equals("add") && portletId != null) {
            this.addPortlet(httpServletRequest, httpServletResponse, portletId);
        }
        return "";
    }

    protected void addPortlet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId) throws Exception {
        Action renderPortletAction = (Action)InstancePool.get(RenderPortletAction.class.getName());
        long companyId = PortalUtil.getCompanyId(httpServletRequest);
        Portlet portlet = PortletLocalServiceUtil.getPortletById(companyId, portletId);
        DynamicServletRequest dynamicRequest = null;
        if (portlet.isPrivateRequestAttributes()) {
            String portletNamespace = PortalUtil.getPortletNamespace(portlet.getPortletId());
            dynamicRequest = new NamespaceServletRequest(httpServletRequest, portletNamespace, portletNamespace);
        } else {
            dynamicRequest = new DynamicServletRequest(httpServletRequest);
        }
        dynamicRequest.setParameter("p_p_id", portletId);
        String dataType = StringUtil.toLowerCase(ParamUtil.getString(httpServletRequest, "dataType"));
        if (dataType.equals("json")) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(httpServletResponse);
            renderPortletAction.execute(null, (HttpServletRequest)dynamicRequest, (HttpServletResponse)bufferCacheServletResponse);
            String portletHTML = bufferCacheServletResponse.getString();
            portletHTML = portletHTML.trim();
            PortletJSONUtil.populatePortletJSONObject(httpServletRequest, portletHTML, portlet, jsonObject);
            httpServletResponse.setContentType("application/json");
            ServletResponseUtil.write(httpServletResponse, jsonObject.toString());
        } else {
            renderPortletAction.execute(null, (HttpServletRequest)dynamicRequest, httpServletResponse);
        }
    }

    protected void storeAddContentPortletPreferences(HttpServletRequest httpServletRequest, Layout layout, String portletId, ThemeDisplay themeDisplay) throws Exception {
        PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getLayoutPortletSetup(layout, portletId);
        String[] portletData = StringUtil.split(ParamUtil.getString(httpServletRequest, "portletData"));
        if (portletData.length == 0) {
            return;
        }
        long classPK = GetterUtil.getLong(portletData[0]);
        String className = GetterUtil.getString(portletData[1]);
        if (classPK <= 0L || Validator.isNull(className)) {
            return;
        }
        AddPortletProvider addPortletProvider = _serviceTrackerMap.getService(className);
        if (addPortletProvider == null) {
            addPortletProvider = _serviceTrackerMap.getService(AssetEntry.class.getName());
        }
        if (addPortletProvider != null) {
            addPortletProvider.updatePortletPreferences(portletSetup, portletId, className, classPK, themeDisplay);
        }
        portletSetup.store();
    }
}

