/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.FriendlyURLResolverRegistryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.admin.util.AdminUtil;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class UpdateLanguageAction
implements Action {
    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String languageId = ParamUtil.getString(httpServletRequest, "languageId");
        Locale locale = LocaleUtil.fromLanguageId(languageId);
        if (LanguageUtil.isAvailableLocale(themeDisplay.getSiteGroupId(), locale)) {
            boolean persistState = ParamUtil.getBoolean(httpServletRequest, "persistState", true);
            if (themeDisplay.isSignedIn() && persistState) {
                User user = themeDisplay.getUser();
                Contact contact = user.getContact();
                AdminUtil.updateUser(httpServletRequest, user.getUserId(), user.getScreenName(), user.getEmailAddress(), user.getFacebookId(), user.getOpenId(), languageId, user.getTimeZoneId(), user.getGreeting(), user.getComments(), contact.getSmsSn(), contact.getFacebookSn(), contact.getJabberSn(), contact.getSkypeSn(), contact.getTwitterSn());
            }
            HttpSession session = httpServletRequest.getSession();
            session.setAttribute("LOCALE", (Object)locale);
            LanguageUtil.updateCookie(httpServletRequest, httpServletResponse, locale);
        }
        String redirect = PortalUtil.escapeRedirect(ParamUtil.getString(httpServletRequest, "redirect"));
        String layoutURL = "";
        String queryString = "";
        int pos = redirect.indexOf("/-/");
        if (pos == -1) {
            pos = redirect.indexOf("?");
        }
        if (pos != -1) {
            layoutURL = redirect.substring(0, pos);
            queryString = redirect.substring(pos);
        } else {
            layoutURL = redirect;
        }
        Layout layout = themeDisplay.getLayout();
        if (this.isFriendlyURLResolver(layoutURL)) {
            redirect = layoutURL;
            if (themeDisplay.isI18n()) {
                String i18nPath = themeDisplay.getI18nPath();
                redirect = redirect.substring(i18nPath.length());
            }
        } else if (this.isGroupFriendlyURL(layout.getGroup(), layout, layoutURL, locale)) {
            if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 0) {
                redirect = layoutURL;
                if (themeDisplay.isI18n()) {
                    String i18nPath = themeDisplay.getI18nPath();
                    redirect = redirect.substring(i18nPath.length());
                }
            } else {
                redirect = PortalUtil.getGroupFriendlyURL(layout.getLayoutSet(), themeDisplay, locale);
            }
        } else if (layout.isTypeControlPanel() && themeDisplay.isI18n()) {
            String i18nPath = themeDisplay.getI18nPath();
            redirect = redirect.substring(i18nPath.length());
        } else {
            redirect = PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 0 ? PortalUtil.getLayoutURL(layout, themeDisplay, locale) : PortalUtil.getLayoutFriendlyURL(layout, themeDisplay, locale);
        }
        if (Validator.isNotNull(queryString)) {
            redirect = redirect + queryString;
        }
        httpServletResponse.sendRedirect(redirect);
        return null;
    }

    protected boolean isFriendlyURLResolver(String layoutURL) {
        String[] urlSeparators;
        for (String urlSeparator : urlSeparators = FriendlyURLResolverRegistryUtil.getURLSeparators()) {
            if (!layoutURL.contains(urlSeparator)) continue;
            return true;
        }
        return false;
    }

    protected boolean isGroupFriendlyURL(Group group, Layout layout, String layoutURL, Locale locale) {
        if (Validator.isNull(layoutURL)) {
            return true;
        }
        int pos = layoutURL.lastIndexOf(47);
        String layoutURLLanguageId = layoutURL.substring(pos + 1);
        Locale layoutURLLocale = LocaleUtil.fromLanguageId(layoutURLLanguageId, true, false);
        if (layoutURLLocale != null) {
            return true;
        }
        return PortalUtil.isGroupFriendlyURL(layoutURL, group.getFriendlyURL(), layout.getFriendlyURL(locale));
    }
}

