/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.layouts.admin.kernel.util.SitemapUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutSetException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SitemapAction
implements Action {
    private static final Log _log = LogFactoryUtil.getLog(SitemapAction.class);

    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            String layoutUuid = ParamUtil.getString(httpServletRequest, "layoutUuid");
            long groupId = ParamUtil.getLong(httpServletRequest, "groupId");
            LayoutSet layoutSet = null;
            if (groupId > 0L) {
                Group group = GroupLocalServiceUtil.getGroup(groupId);
                if (group.isStagingGroup()) {
                    groupId = group.getLiveGroupId();
                }
                boolean privateLayout = ParamUtil.getBoolean(httpServletRequest, "privateLayout");
                layoutSet = LayoutSetLocalServiceUtil.getLayoutSet(groupId, privateLayout);
            } else {
                String host = PortalUtil.getHost(httpServletRequest);
                host = StringUtil.toLowerCase(host);
                VirtualHost virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost(host = host.trim());
                if (virtualHost != null && virtualHost.getLayoutSetId() != 0L) {
                    layoutSet = LayoutSetLocalServiceUtil.getLayoutSet(virtualHost.getLayoutSetId());
                } else {
                    String groupName = PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME;
                    if (Validator.isNull(groupName)) {
                        groupName = "Guest";
                    }
                    Group group = GroupLocalServiceUtil.getGroup(themeDisplay.getCompanyId(), groupName);
                    layoutSet = LayoutSetLocalServiceUtil.getLayoutSet(group.getGroupId(), false);
                }
            }
            String sitemap = SitemapUtil.getSitemap(layoutUuid, layoutSet.getGroupId(), layoutSet.isPrivateLayout(), themeDisplay);
            ServletResponseUtil.sendFile(httpServletRequest, httpServletResponse, null, sitemap.getBytes("UTF-8"), "text/xml; charset=UTF-8");
        }
        catch (NoSuchLayoutSetException nslse) {
            PortalUtil.sendError(404, (Exception)nslse, httpServletRequest, httpServletResponse);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn(e, e);
            }
            PortalUtil.sendError(500, e, httpServletRequest, httpServletResponse);
        }
        return null;
    }
}

