/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.taglib.ui.util.SessionTreeJSClicks;
import java.util.ConcurrentModificationException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionTreeJSClickAction
implements Action {
    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            String cmd = ParamUtil.getString(httpServletRequest, "cmd");
            String treeId = ParamUtil.getString(httpServletRequest, "treeId");
            if (cmd.equals("collapse")) {
                SessionTreeJSClicks.closeNodes(httpServletRequest, treeId);
            } else if (cmd.equals("expand")) {
                String[] nodeIds = StringUtil.split(ParamUtil.getString(httpServletRequest, "nodeIds"));
                SessionTreeJSClicks.openNodes(httpServletRequest, treeId, nodeIds);
            } else if (cmd.equals("layoutCheck")) {
                long plid = ParamUtil.getLong(httpServletRequest, "plid");
                if (plid == 0L) {
                    boolean privateLayout = ParamUtil.getBoolean(httpServletRequest, "privateLayout");
                    SessionTreeJSClicks.openLayoutNodes(httpServletRequest, treeId, privateLayout, 0L, true);
                } else {
                    boolean recursive = ParamUtil.getBoolean(httpServletRequest, "recursive");
                    Layout layout = LayoutLocalServiceUtil.getLayout(plid);
                    SessionTreeJSClicks.openLayoutNodes(httpServletRequest, treeId, layout.isPrivateLayout(), layout.getLayoutId(), recursive);
                }
            } else if (!cmd.equals("layoutCollapse")) {
                if (cmd.equals("layoutUncheck")) {
                    long plid = ParamUtil.getLong(httpServletRequest, "plid");
                    if (plid == 0L) {
                        SessionTreeJSClicks.closeNodes(httpServletRequest, treeId);
                    } else {
                        boolean recursive = ParamUtil.getBoolean(httpServletRequest, "recursive");
                        Layout layout = LayoutLocalServiceUtil.getLayout(plid);
                        SessionTreeJSClicks.closeLayoutNodes(httpServletRequest, treeId, layout.isPrivateLayout(), layout.getLayoutId(), recursive);
                    }
                } else if (!cmd.equals("layoutUncollapse")) {
                    String nodeId = ParamUtil.getString(httpServletRequest, "nodeId");
                    boolean openNode = ParamUtil.getBoolean(httpServletRequest, "openNode");
                    if (openNode) {
                        SessionTreeJSClicks.openNode(httpServletRequest, treeId, nodeId);
                    } else {
                        SessionTreeJSClicks.closeNode(httpServletRequest, treeId, nodeId);
                    }
                }
            }
            if (!cmd.isEmpty()) {
                this.updateCheckedLayoutPlids(httpServletRequest, treeId);
            }
            httpServletResponse.setContentType("application/json");
            PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences(httpServletRequest);
            String json = portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId + "Plid");
            if (Validator.isNotNull(json)) {
                ServletResponseUtil.write(httpServletResponse, json);
            }
            return null;
        }
        catch (Exception e) {
            PortalUtil.sendError(e, httpServletRequest, httpServletResponse);
            return null;
        }
    }

    protected void updateCheckedLayoutPlids(HttpServletRequest httpServletRequest, String treeId) {
        long groupId = ParamUtil.getLong(httpServletRequest, "groupId");
        boolean privateLayout = ParamUtil.getBoolean(httpServletRequest, "privateLayout");
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        while (true) {
            try {
                long[] checkedLayoutIds;
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences(httpServletRequest);
                for (long checkedLayoutId : checkedLayoutIds = StringUtil.split(portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId), 0L)) {
                    Layout checkedLayout;
                    if (checkedLayoutId == 0L) {
                        jsonArray.put(String.valueOf(0L));
                    }
                    if ((checkedLayout = LayoutLocalServiceUtil.fetchLayout(groupId, privateLayout, checkedLayoutId)) == null) continue;
                    jsonArray.put(String.valueOf(checkedLayout.getPlid()));
                }
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId + "Plid", jsonArray.toString());
                return;
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
    }
}

