/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SessionClicks;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import java.util.Enumeration;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SessionClickAction
implements Action {
    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            AuthTokenUtil.checkCSRFToken(httpServletRequest, SessionClickAction.class.getName());
            HttpSession session = httpServletRequest.getSession();
            Enumeration enu = httpServletRequest.getParameterNames();
            boolean useHttpSession = ParamUtil.getBoolean(httpServletRequest, "useHttpSession");
            while (enu.hasMoreElements()) {
                String name = (String)enu.nextElement();
                if (name.equals("doAsUserId") || name.equals("p_auth")) continue;
                String value = ParamUtil.getString(httpServletRequest, name);
                if (useHttpSession) {
                    SessionClicks.put(session, name, value);
                    continue;
                }
                SessionClicks.put(httpServletRequest, name, value);
            }
            String value = this.getValue(httpServletRequest);
            if (value != null) {
                String cmd = ParamUtil.getString(httpServletRequest, "cmd");
                if (cmd.equals("get")) {
                    httpServletResponse.setContentType("text/plain");
                } else {
                    httpServletResponse.setContentType("application/json");
                }
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                servletOutputStream.print(value);
            }
            return null;
        }
        catch (Exception e) {
            PortalUtil.sendError(e, httpServletRequest, httpServletResponse);
            return null;
        }
    }

    protected String getValue(HttpServletRequest httpServletRequest) {
        HttpSession session = httpServletRequest.getSession();
        String cmd = ParamUtil.getString(httpServletRequest, "cmd");
        boolean useHttpSession = ParamUtil.getBoolean(httpServletRequest, "useHttpSession");
        if (cmd.equals("get")) {
            String key = ParamUtil.getString(httpServletRequest, "key");
            String value = "";
            value = useHttpSession ? SessionClicks.get(session, key, cmd) : SessionClicks.get(httpServletRequest, key, cmd);
            return value;
        }
        if (cmd.equals("getAll")) {
            String[] keys;
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            for (String key : keys = httpServletRequest.getParameterValues("key")) {
                String value = "";
                value = useHttpSession ? SessionClicks.get(session, key, cmd) : SessionClicks.get(httpServletRequest, key, cmd);
                jsonObject.put(key, value);
            }
            return jsonObject.toString();
        }
        return null;
    }
}

