/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.RobotsUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RobotsAction
implements Action {
    private static final Log _log = LogFactoryUtil.getLog(RobotsAction.class);

    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            String host = GetterUtil.getString(PortalUtil.getHost(httpServletRequest));
            LayoutSet layoutSet = null;
            VirtualHost virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost(host);
            if (virtualHost != null && virtualHost.getLayoutSetId() > 0L) {
                layoutSet = LayoutSetLocalServiceUtil.fetchLayoutSet(host);
            } else {
                Company company = PortalUtil.getCompany(httpServletRequest);
                if (host.equals(company.getVirtualHostname()) && Validator.isNotNull(PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME)) {
                    Group defaultGroup = GroupLocalServiceUtil.getGroup(company.getCompanyId(), PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME);
                    layoutSet = defaultGroup.getPublicLayoutSet();
                }
            }
            String robots = RobotsUtil.getRobots(layoutSet, httpServletRequest.isSecure());
            ServletResponseUtil.sendFile(httpServletRequest, httpServletResponse, null, robots.getBytes("UTF-8"), "text/plain; charset=UTF-8");
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn(e, e);
            }
            PortalUtil.sendError(500, e, httpServletRequest, httpServletResponse);
        }
        return null;
    }
}

