/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.struts.JSONAction;
import com.liferay.ratings.kernel.model.RatingsStats;
import com.liferay.ratings.kernel.service.RatingsEntryServiceUtil;
import com.liferay.ratings.kernel.service.RatingsStatsLocalServiceUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RateEntryAction
extends JSONAction {
    @Override
    public String getJSON(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String className = this.getClassName(httpServletRequest);
        long classPK = this.getClassPK(httpServletRequest);
        double score = ParamUtil.getDouble(httpServletRequest, "score");
        if (score == -1.0) {
            RatingsEntryServiceUtil.deleteEntry(className, classPK);
        } else {
            RatingsEntryServiceUtil.updateEntry(className, classPK, score);
        }
        RatingsStats stats = RatingsStatsLocalServiceUtil.fetchStats(className, classPK);
        double averageScore = 0.0;
        int totalEntries = 0;
        double totalScore = 0.0;
        if (stats != null) {
            averageScore = stats.getAverageScore();
            totalEntries = stats.getTotalEntries();
            totalScore = stats.getTotalScore();
        }
        JSONObject jsonObject = JSONUtil.put("averageScore", (Object)averageScore).put("score", score).put("totalEntries", totalEntries).put("totalScore", totalScore);
        return jsonObject.toString();
    }

    protected String getClassName(HttpServletRequest httpServletRequest) {
        return ParamUtil.getString(httpServletRequest, "className");
    }

    protected long getClassPK(HttpServletRequest httpServletRequest) {
        return ParamUtil.getLong(httpServletRequest, "classPK");
    }
}

