/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RESTProxyAction
implements Action {
    private static final Log _log = LogFactoryUtil.getLog(RESTProxyAction.class);

    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String url = ParamUtil.getString(httpServletRequest, "url");
        if (!this.validate(url)) {
            return null;
        }
        Http.Options options = new Http.Options();
        int pos = url.indexOf(63);
        if (pos != -1) {
            options.setBody(url.substring(pos + 1), "application/x-www-form-urlencoded", "UTF-8");
            options.setLocation(url.substring(0, pos));
        } else {
            options.setLocation(url);
        }
        options.setPost(true);
        String content = HttpUtil.URLtoString(options);
        ServletResponseUtil.write(httpServletResponse, content);
        return null;
    }

    protected boolean validate(String url) {
        if (Validator.isNull(url) || !HttpUtil.hasDomain(url)) {
            return false;
        }
        if (PropsValues.REST_PROXY_URL_PREFIXES_ALLOWED.length == 0) {
            return true;
        }
        for (String urlPrefix : PropsValues.REST_PROXY_URL_PREFIXES_ALLOWED) {
            if (!StringUtil.startsWith(url, urlPrefix)) continue;
            return true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("URL " + url + " is not allowed");
        }
        return false;
    }
}

