/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.WindowStateFactory;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManagerUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.SSOUtil;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.util.PropsValues;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LoginAction
implements Action {
    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String portalURLSecure;
        String portalURL;
        String redirect;
        HttpSession session;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            httpServletResponse.sendRedirect(themeDisplay.getPathMain() + PropsValues.AUTH_LOGIN_DISABLED_PATH);
            return null;
        }
        if (PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS && !httpServletRequest.isSecure()) {
            StringBundler sb = new StringBundler(4);
            sb.append(PortalUtil.getPortalURL(httpServletRequest, true));
            sb.append(httpServletRequest.getRequestURI());
            sb.append("?");
            sb.append(httpServletRequest.getQueryString());
            httpServletResponse.sendRedirect(sb.toString());
            return null;
        }
        String login = ParamUtil.getString(httpServletRequest, "login");
        String password = httpServletRequest.getParameter("password");
        if (Validator.isNotNull(login) && Validator.isNotNull(password)) {
            AuthTokenUtil.checkCSRFToken(httpServletRequest, LoginAction.class.getName());
            boolean rememberMe = ParamUtil.getBoolean(httpServletRequest, "rememberMe");
            String authType = ParamUtil.getString(httpServletRequest, "authType");
            AuthenticatedSessionManagerUtil.login(httpServletRequest, httpServletResponse, login, password, rememberMe, authType);
        }
        if ((session = httpServletRequest.getSession()).getAttribute("j_username") != null && session.getAttribute("j_password") != null) {
            String portalURL2;
            if (PropsValues.PORTAL_JAAS_ENABLE) {
                return actionMapping.getActionForward("/portal/touch_protected.jsp");
            }
            redirect = ParamUtil.getString(httpServletRequest, "redirect");
            if (Validator.isNull(redirect = PortalUtil.escapeRedirect(redirect))) {
                redirect = themeDisplay.getPathMain();
            }
            if (redirect.charAt(0) == '/' && Validator.isNotNull(portalURL2 = PortalUtil.getPortalURL(httpServletRequest, httpServletRequest.isSecure()))) {
                redirect = portalURL2.concat(redirect);
            }
            httpServletResponse.sendRedirect(redirect);
            return null;
        }
        redirect = PortalUtil.getSiteLoginURL(themeDisplay);
        if (Validator.isNull(redirect)) {
            redirect = PropsValues.AUTH_LOGIN_URL;
        }
        if (Validator.isNull(redirect)) {
            LiferayPortletURL portletURL = PortletURLFactoryUtil.create(httpServletRequest, "com_liferay_login_web_portlet_LoginPortlet", "RENDER_PHASE");
            portletURL.setParameter("saveLastPath", Boolean.FALSE.toString());
            portletURL.setParameter("mvcRenderCommandName", "/login/login");
            portletURL.setPortletMode(PortletMode.VIEW);
            portletURL.setWindowState(this.getWindowState(httpServletRequest));
            redirect = portletURL.toString();
        }
        if (PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS && !(portalURL = PortalUtil.getPortalURL(httpServletRequest)).equals(portalURLSecure = PortalUtil.getPortalURL(httpServletRequest, true))) {
            redirect = StringUtil.replaceFirst(redirect, portalURL, portalURLSecure);
        }
        String loginRedirect = ParamUtil.getString(httpServletRequest, "redirect");
        if (Validator.isNotNull(loginRedirect = PortalUtil.escapeRedirect(loginRedirect))) {
            if (SSOUtil.isRedirectRequired(themeDisplay.getCompanyId())) {
                redirect = loginRedirect;
            } else {
                String loginPortletNamespace = PortalUtil.getPortletNamespace(PropsValues.AUTH_LOGIN_PORTLET_NAME);
                String loginRedirectParameter = loginPortletNamespace + "redirect";
                redirect = HttpUtil.setParameter(redirect, "p_p_id", PropsValues.AUTH_LOGIN_PORTLET_NAME);
                redirect = HttpUtil.setParameter(redirect, "p_p_lifecycle", "0");
                redirect = HttpUtil.setParameter(redirect, loginRedirectParameter, loginRedirect);
            }
        }
        httpServletResponse.sendRedirect(redirect);
        return null;
    }

    protected WindowState getWindowState(HttpServletRequest httpServletRequest) {
        WindowState windowState = WindowState.MAXIMIZED;
        String windowStateString = ParamUtil.getString(httpServletRequest, "windowState");
        if (Validator.isNotNull(windowStateString)) {
            windowState = WindowStateFactory.getWindowState(windowStateString);
        }
        return windowState;
    }
}

