/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouterUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.SSOUtil;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.LiferayPortletUtil;
import com.liferay.portlet.RenderParametersPool;
import com.liferay.portlet.internal.RenderData;
import com.liferay.portlet.internal.RenderStateUtil;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LayoutAction
implements Action {
    private static final Log _log = LogFactoryUtil.getLog(LayoutAction.class);

    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Boolean layoutDefault = (Boolean)httpServletRequest.getAttribute("LAYOUT_DEFAULT");
        if (Boolean.TRUE.equals(layoutDefault)) {
            Layout requestedLayout = (Layout)httpServletRequest.getAttribute("REQUESTED_LAYOUT");
            if (requestedLayout != null) {
                String authLoginURL;
                String redirectParam = "redirect";
                if (Validator.isNotNull(PropsValues.AUTH_LOGIN_PORTLET_NAME)) {
                    String portletNamespace = PortalUtil.getPortletNamespace(PropsValues.AUTH_LOGIN_PORTLET_NAME);
                    redirectParam = portletNamespace + redirectParam;
                }
                if (Validator.isNull(authLoginURL = SSOUtil.getSignInURL(themeDisplay.getCompanyId(), themeDisplay.getURLSignIn()))) {
                    authLoginURL = PortalUtil.getSiteLoginURL(themeDisplay);
                }
                if (Validator.isNull(authLoginURL)) {
                    authLoginURL = PropsValues.AUTH_LOGIN_URL;
                }
                if (Validator.isNull(authLoginURL)) {
                    LiferayPortletURL loginURL = PortletURLFactoryUtil.create(httpServletRequest, "com_liferay_login_web_portlet_LoginPortlet", "RENDER_PHASE");
                    loginURL.setParameter("saveLastPath", Boolean.FALSE.toString());
                    loginURL.setParameter("mvcRenderCommandName", "/login/login");
                    loginURL.setPortletMode(PortletMode.VIEW);
                    loginURL.setWindowState(WindowState.MAXIMIZED);
                    authLoginURL = loginURL.toString();
                }
                authLoginURL = HttpUtil.setParameter(authLoginURL, "p_p_id", PropsValues.AUTH_LOGIN_PORTLET_NAME);
                String currentURL = PortalUtil.getCurrentURL(httpServletRequest);
                authLoginURL = HttpUtil.setParameter(authLoginURL, redirectParam, currentURL);
                if (_log.isDebugEnabled()) {
                    _log.debug("Redirect requested layout to " + authLoginURL);
                }
                httpServletResponse.sendRedirect(authLoginURL);
            } else {
                Layout layout = themeDisplay.getLayout();
                String redirect = PortalUtil.getLayoutURL(layout, themeDisplay);
                if (_log.isDebugEnabled()) {
                    _log.debug("Redirect default layout to " + redirect);
                }
                httpServletResponse.sendRedirect(redirect);
            }
            return null;
        }
        long plid = ParamUtil.getLong(httpServletRequest, "p_l_id");
        if (_log.isDebugEnabled()) {
            _log.debug("p_l_id is " + plid);
        }
        if (plid > 0L) {
            Layout layout = themeDisplay.getLayout();
            if (layout != null) {
                plid = layout.getPlid();
            }
            return this.processLayout(actionMapping, httpServletRequest, httpServletResponse, plid);
        }
        try {
            this.forwardLayout(httpServletRequest);
            return actionMapping.getActionForward("/common/forward_jsp.jsp");
        }
        catch (Exception e) {
            PortalUtil.sendError(e, httpServletRequest, httpServletResponse);
            return null;
        }
    }

    protected void forwardLayout(HttpServletRequest httpServletRequest) throws Exception {
        String forwardURL;
        Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        long plid = 0L;
        String layoutFriendlyURL = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (layout != null) {
            plid = layout.getPlid();
            layoutFriendlyURL = PortalUtil.getLayoutFriendlyURL(layout, themeDisplay);
        }
        if (Validator.isNull(forwardURL = layoutFriendlyURL)) {
            forwardURL = themeDisplay.getPathMain() + "/portal/layout?p_l_id=" + plid;
        }
        if (Validator.isNotNull(themeDisplay.getDoAsUserId())) {
            forwardURL = HttpUtil.addParameter(forwardURL, "doAsUserId", themeDisplay.getDoAsUserId());
        }
        if (Validator.isNotNull(themeDisplay.getDoAsUserLanguageId())) {
            forwardURL = HttpUtil.addParameter(forwardURL, "doAsUserLanguageId", themeDisplay.getDoAsUserLanguageId());
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Forward layout to " + forwardURL);
        }
        httpServletRequest.setAttribute("FORWARD_URL", (Object)forwardURL);
    }

    protected String getRenderStateJSON(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ThemeDisplay themeDisplay, String portletId, LayoutTypePortlet layoutTypePortlet) throws Exception {
        HashMap<String, RenderData> renderDataMap = new HashMap<String, RenderData>();
        List<Portlet> allPortlets = layoutTypePortlet.getAllPortlets();
        for (Portlet curPortlet : allPortlets) {
            String curPortletId = curPortlet.getPortletId();
            if (!curPortletId.equals(portletId) && !curPortlet.isPartialActionServeResource()) continue;
            BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(httpServletResponse);
            PortletContainerUtil.preparePortlet(httpServletRequest, curPortlet);
            PortletContainerUtil.serveResource(httpServletRequest, (HttpServletResponse)bufferCacheServletResponse, curPortlet);
            RenderData renderData = new RenderData(bufferCacheServletResponse.getContentType(), bufferCacheServletResponse.getString());
            renderDataMap.put(curPortletId, renderData);
        }
        return RenderStateUtil.generateJSON(httpServletRequest, themeDisplay, renderDataMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActionForward processLayout(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long plid) throws Exception {
        HttpSession session = httpServletRequest.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            Layout layout = themeDisplay.getLayout();
            if (layout != null && layout.isTypeURL()) {
                String redirect = PortalUtil.getLayoutActualURL(layout);
                httpServletResponse.sendRedirect(redirect);
                ActionForward actionForward = null;
                return actionForward;
            }
            Long previousLayoutPlid = (Long)session.getAttribute("PREVIOUS_LAYOUT_PLID");
            if (previousLayoutPlid == null || layout.getPlid() != previousLayoutPlid.longValue()) {
                session.setAttribute("PREVIOUS_LAYOUT_PLID", (Object)layout.getPlid());
                if (themeDisplay.isSignedIn() && PropsValues.AUDIT_MESSAGE_COM_LIFERAY_PORTAL_MODEL_LAYOUT_VIEW && AuditRouterUtil.isDeployed()) {
                    User user = themeDisplay.getUser();
                    AuditMessage auditMessage = new AuditMessage("VIEW", user.getCompanyId(), user.getUserId(), user.getFullName(), Layout.class.getName(), String.valueOf(layout.getPlid()));
                    AuditRouterUtil.route(auditMessage);
                }
            }
            boolean resetLayout = ParamUtil.getBoolean(httpServletRequest, "p_l_reset", PropsValues.LAYOUT_DEFAULT_P_L_RESET);
            String portletId = ParamUtil.getString(httpServletRequest, "p_p_id");
            if (resetLayout && (Validator.isNull(portletId) || previousLayoutPlid != null && layout.getPlid() != previousLayoutPlid.longValue())) {
                RenderParametersPool.clear(httpServletRequest, plid);
            }
            Portlet portlet = null;
            if (Validator.isNotNull(portletId)) {
                long companyId = PortalUtil.getCompanyId(httpServletRequest);
                portlet = PortletLocalServiceUtil.getPortletById(companyId, portletId);
            }
            if (portlet != null) {
                PortletContainerUtil.preparePortlet(httpServletRequest, portlet);
                if (themeDisplay.isLifecycleAction()) {
                    LayoutTypePortlet layoutTypePortlet;
                    PortletContainerUtil.processAction(httpServletRequest, httpServletResponse, portlet);
                    if (httpServletResponse.isCommitted()) {
                        ActionForward companyId = null;
                        return companyId;
                    }
                    String renderStateJSON = "";
                    if (themeDisplay.isHubAction()) {
                        renderStateJSON = RenderStateUtil.generateJSON(httpServletRequest, themeDisplay);
                    } else if (themeDisplay.isHubPartialAction() && (layoutTypePortlet = themeDisplay.getLayoutTypePortlet()) != null) {
                        renderStateJSON = this.getRenderStateJSON(httpServletRequest, httpServletResponse, themeDisplay, portlet.getPortletId(), layoutTypePortlet);
                    }
                    if (themeDisplay.isHubAction() || themeDisplay.isHubPartialAction()) {
                        httpServletResponse.setContentLength(renderStateJSON.length());
                        httpServletResponse.setContentType("application/json");
                        PrintWriter printWriter = httpServletResponse.getWriter();
                        printWriter.write(renderStateJSON);
                        ActionForward liferayPortletRequest = null;
                        return liferayPortletRequest;
                    }
                } else if (themeDisplay.isLifecycleResource()) {
                    PortletContainerUtil.serveResource(httpServletRequest, httpServletResponse, portlet);
                    ActionForward actionForward = null;
                    return actionForward;
                }
            }
            if (layout != null) {
                if (themeDisplay.isStateExclusive()) {
                    PortletContainerUtil.renderHeaders(httpServletRequest, httpServletResponse, portlet);
                    PortletContainerUtil.render(httpServletRequest, httpServletResponse, portlet);
                    ActionForward actionForward = null;
                    return actionForward;
                }
                PortletContainerUtil.processPublicRenderParameters(httpServletRequest, layout, portlet);
                if (layout.includeLayoutContent(httpServletRequest, httpServletResponse)) {
                    ActionForward actionForward = null;
                    return actionForward;
                }
            }
            ActionForward actionForward = actionMapping.getActionForward("portal.layout");
            return actionForward;
        }
        catch (Exception e) {
            PortalUtil.sendError(e, httpServletRequest, httpServletResponse);
            ActionForward actionForward = null;
            return actionForward;
        }
        finally {
            PortletRequest portletRequest;
            if (!ServerDetector.isResin() && (portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request")) != null) {
                LiferayPortletRequest liferayPortletRequest = LiferayPortletUtil.getLiferayPortletRequest(portletRequest);
                if (liferayPortletRequest instanceof ResourceRequest) {
                    ResourceRequest resourceRequest = (ResourceRequest)liferayPortletRequest;
                    if (!resourceRequest.isAsyncStarted()) {
                        liferayPortletRequest.cleanUp();
                    }
                } else {
                    liferayPortletRequest.cleanUp();
                }
            }
        }
    }
}

