/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONSerializable;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.JSONAction;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSONServiceAction
extends JSONAction {
    private static final String _REROUTE_PATH = "/api/json";
    private static final Log _log = LogFactoryUtil.getLog(JSONServiceAction.class);
    private static final Pattern _fieldDescriptorPattern = Pattern.compile("^(.*?)((\\[\\])*)$", 32);
    private final Set<String> _invalidClassNames;
    private final Set<String> _invalidMethodNames;
    private final Map<String, Object[]> _methodCache = new HashMap<String, Object[]>();

    public JSONServiceAction() {
        this._invalidClassNames = SetUtil.fromArray(PropsValues.JSON_SERVICE_INVALID_CLASS_NAMES);
        this._invalidMethodNames = SetUtil.fromArray(PropsValues.JSON_SERVICE_INVALID_METHOD_NAMES);
        if (_log.isDebugEnabled()) {
            for (String invalidClassName : this._invalidClassNames) {
                _log.debug("Invalid class name " + invalidClassName);
            }
            for (String invalidMethodName : this._invalidMethodNames) {
                _log.debug("Invalid method name " + invalidMethodName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJSON(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String className = ParamUtil.getString(httpServletRequest, "serviceClassName");
        String methodName = ParamUtil.getString(httpServletRequest, "serviceMethodName");
        String[] serviceParameters = this.getStringArrayFromJSON(httpServletRequest, "serviceParameters");
        String[] serviceParameterTypes = this.getStringArrayFromJSON(httpServletRequest, "serviceParameterTypes");
        if (!this.isValidRequest(httpServletRequest)) {
            return null;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        Class<?> clazz = contextClassLoader.loadClass(className);
        Object[] methodAndParameterTypes = this.getMethodAndParameterTypes(clazz, methodName, serviceParameters, serviceParameterTypes);
        if (methodAndParameterTypes == null) {
            return null;
        }
        Method method = (Method)methodAndParameterTypes[0];
        Type[] parameterTypes = (Type[])methodAndParameterTypes[1];
        Object[] args = new Object[serviceParameters.length];
        for (int i = 0; i < serviceParameters.length; ++i) {
            args[i] = this.getArgValue(httpServletRequest, clazz, methodName, serviceParameters[i], parameterTypes[i]);
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug(StringBundler.concat("Invoking ", clazz, " on method ", method.getName(), " with args ", Arrays.toString(args)));
            }
            Object returnObj = null;
            boolean remoteAccess = AccessControlThreadLocal.isRemoteAccess();
            try {
                AccessControlThreadLocal.setRemoteAccess(true);
                returnObj = method.invoke(clazz, args);
            }
            finally {
                AccessControlThreadLocal.setRemoteAccess(remoteAccess);
            }
            if (returnObj != null) {
                return this.getReturnValue(returnObj);
            }
            return JSONFactoryUtil.getNullJSON();
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug(StringBundler.concat("Invoked ", clazz, " on method ", method.getName(), " with args ", Arrays.toString(args)), e);
            }
            return JSONFactoryUtil.serializeThrowable(e);
        }
    }

    protected Object getArgValue(HttpServletRequest httpServletRequest, Class<?> clazz, String methodName, String parameter, Type parameterType) throws Exception {
        String typeNameOrClassDescriptor = this.getTypeNameOrClassDescriptor(parameterType);
        String value = ParamUtil.getString(httpServletRequest, parameter);
        if (Validator.isNull(value) && !typeNameOrClassDescriptor.equals("[Ljava.lang.String;")) {
            return null;
        }
        if (typeNameOrClassDescriptor.equals("boolean") || typeNameOrClassDescriptor.equals(Boolean.class.getName())) {
            return ParamUtil.getBoolean(httpServletRequest, parameter);
        }
        if (typeNameOrClassDescriptor.equals("double") || typeNameOrClassDescriptor.equals(Double.class.getName())) {
            return ParamUtil.getDouble(httpServletRequest, parameter);
        }
        if (typeNameOrClassDescriptor.equals("int") || typeNameOrClassDescriptor.equals(Integer.class.getName())) {
            return ParamUtil.getInteger(httpServletRequest, parameter);
        }
        if (typeNameOrClassDescriptor.equals("long") || typeNameOrClassDescriptor.equals(Long.class.getName())) {
            return ParamUtil.getLong(httpServletRequest, parameter);
        }
        if (typeNameOrClassDescriptor.equals("short") || typeNameOrClassDescriptor.equals(Short.class.getName())) {
            return ParamUtil.getShort(httpServletRequest, parameter);
        }
        if (typeNameOrClassDescriptor.equals(Calendar.class.getName())) {
            Calendar cal = Calendar.getInstance(LocaleUtil.getDefault());
            cal.setTimeInMillis(ParamUtil.getLong(httpServletRequest, parameter));
            return cal;
        }
        if (typeNameOrClassDescriptor.equals(Date.class.getName())) {
            return new Date(ParamUtil.getLong(httpServletRequest, parameter));
        }
        if (typeNameOrClassDescriptor.equals(ServiceContext.class.getName())) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject(value);
            jsonObject.put("javaClass", ServiceContext.class.getName());
            return ServiceContextUtil.deserialize(jsonObject);
        }
        if (typeNameOrClassDescriptor.equals(String.class.getName())) {
            return value;
        }
        if (typeNameOrClassDescriptor.equals("[Z")) {
            return ParamUtil.getBooleanValues(httpServletRequest, parameter);
        }
        if (typeNameOrClassDescriptor.equals("[D")) {
            return ParamUtil.getDoubleValues(httpServletRequest, parameter);
        }
        if (typeNameOrClassDescriptor.equals("[F")) {
            return ParamUtil.getFloatValues(httpServletRequest, parameter);
        }
        if (typeNameOrClassDescriptor.equals("[I")) {
            return ParamUtil.getIntegerValues(httpServletRequest, parameter);
        }
        if (typeNameOrClassDescriptor.equals("[J")) {
            return ParamUtil.getLongValues(httpServletRequest, parameter);
        }
        if (typeNameOrClassDescriptor.equals("[S")) {
            return ParamUtil.getShortValues(httpServletRequest, parameter);
        }
        if (typeNameOrClassDescriptor.equals("[Ljava.lang.String;")) {
            return ParamUtil.getParameterValues(httpServletRequest, parameter);
        }
        if (typeNameOrClassDescriptor.equals("[[Z")) {
            Object[] values = httpServletRequest.getParameterValues(parameter);
            if (ArrayUtil.isNotEmpty(values)) {
                String[] values0 = StringUtil.split((String)values[0]);
                boolean[][] doubleArray = new boolean[values.length][values0.length];
                for (int i = 0; i < values.length; ++i) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    for (int j = 0; j < curValues.length; ++j) {
                        doubleArray[i][j] = GetterUtil.getBoolean(curValues[j]);
                    }
                }
                return doubleArray;
            }
            return new boolean[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[D")) {
            Object[] values = httpServletRequest.getParameterValues(parameter);
            if (ArrayUtil.isNotEmpty(values)) {
                String[] values0 = StringUtil.split((String)values[0]);
                double[][] doubleArray = new double[values.length][values0.length];
                for (int i = 0; i < values.length; ++i) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    for (int j = 0; j < curValues.length; ++j) {
                        doubleArray[i][j] = GetterUtil.getDouble(curValues[j]);
                    }
                }
                return doubleArray;
            }
            return new double[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[F")) {
            Object[] values = httpServletRequest.getParameterValues(parameter);
            if (ArrayUtil.isNotEmpty(values)) {
                String[] values0 = StringUtil.split((String)values[0]);
                float[][] doubleArray = new float[values.length][values0.length];
                for (int i = 0; i < values.length; ++i) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    for (int j = 0; j < curValues.length; ++j) {
                        doubleArray[i][j] = GetterUtil.getFloat(curValues[j]);
                    }
                }
                return doubleArray;
            }
            return new float[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[I")) {
            Object[] values = httpServletRequest.getParameterValues(parameter);
            if (ArrayUtil.isNotEmpty(values)) {
                String[] values0 = StringUtil.split((String)values[0]);
                int[][] doubleArray = new int[values.length][values0.length];
                for (int i = 0; i < values.length; ++i) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    for (int j = 0; j < curValues.length; ++j) {
                        doubleArray[i][j] = GetterUtil.getInteger(curValues[j]);
                    }
                }
                return doubleArray;
            }
            return new int[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[J")) {
            Object[] values = httpServletRequest.getParameterValues(parameter);
            if (ArrayUtil.isNotEmpty(values)) {
                String[] values0 = StringUtil.split((String)values[0]);
                long[][] doubleArray = new long[values.length][values0.length];
                for (int i = 0; i < values.length; ++i) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    for (int j = 0; j < curValues.length; ++j) {
                        doubleArray[i][j] = GetterUtil.getLong(curValues[j]);
                    }
                }
                return doubleArray;
            }
            return new long[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[S")) {
            Object[] values = httpServletRequest.getParameterValues(parameter);
            if (ArrayUtil.isNotEmpty(values)) {
                String[] values0 = StringUtil.split((String)values[0]);
                short[][] doubleArray = new short[values.length][values0.length];
                for (int i = 0; i < values.length; ++i) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    for (int j = 0; j < curValues.length; ++j) {
                        doubleArray[i][j] = GetterUtil.getShort(curValues[j]);
                    }
                }
                return doubleArray;
            }
            return new short[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[Ljava.lang.String")) {
            Object[] values = httpServletRequest.getParameterValues(parameter);
            if (ArrayUtil.isNotEmpty(values)) {
                String[] values0 = StringUtil.split((String)values[0]);
                String[][] doubleArray = new String[values.length][values0.length];
                for (int i = 0; i < values.length; ++i) {
                    doubleArray[i] = StringUtil.split((String)values[i]);
                }
                return doubleArray;
            }
            return new String[0][0];
        }
        if (typeNameOrClassDescriptor.equals("java.util.Map<java.util.Locale, java.lang.String>")) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject(value);
            return LocalizationUtil.deserialize(jsonObject);
        }
        try {
            return JSONFactoryUtil.looseDeserialize(value);
        }
        catch (Exception e) {
            _log.error(StringBundler.concat("Unsupported parameter type for class ", clazz, ", method ", methodName, ", parameter ", parameter, ", and type ", typeNameOrClassDescriptor));
            return null;
        }
    }

    @Override
    protected String getCSRFOrigin(HttpServletRequest httpServletRequest) {
        StringBundler sb = new StringBundler(6);
        sb.append(ClassUtil.getClassName(this));
        sb.append(":");
        sb.append("/");
        String serviceClassName = ParamUtil.getString(httpServletRequest, "serviceClassName");
        sb.append(serviceClassName);
        sb.append("#");
        String serviceMethodName = ParamUtil.getString(httpServletRequest, "serviceMethodName");
        sb.append(serviceMethodName);
        return sb.toString();
    }

    protected Object[] getMethodAndParameterTypes(Class<?> clazz, String methodName, String[] parameters, String[] parameterTypes) throws Exception {
        Method[] methods;
        StringBundler sb = new StringBundler(5);
        sb.append(clazz.getName());
        sb.append("_METHOD_NAME_");
        sb.append(methodName);
        sb.append("_PARAMETERS_");
        String parameterTypesNames = StringUtil.merge(parameterTypes);
        if (Validator.isNull(parameterTypesNames)) {
            sb.append(parameters.length);
        } else {
            sb.append(parameterTypesNames);
        }
        String key = sb.toString();
        Object[] methodAndParameterTypes = this._methodCache.get(key);
        if (methodAndParameterTypes != null) {
            return methodAndParameterTypes;
        }
        Method method = null;
        Type[] methodParameterTypes = null;
        for (Method curMethod : methods = clazz.getMethods()) {
            Type[] curParameterTypes;
            String curMethodName = curMethod.getName();
            if (!curMethodName.equals(methodName) || (curParameterTypes = curMethod.getGenericParameterTypes()).length != parameters.length) continue;
            if (parameterTypes.length > 0 && parameterTypes.length == curParameterTypes.length) {
                boolean match = true;
                for (int j = 0; j < parameterTypes.length; ++j) {
                    String t1 = parameterTypes[j];
                    String t2 = this.getTypeNameOrClassDescriptor(curParameterTypes[j]);
                    if (t1.equals(t2)) continue;
                    match = false;
                }
                if (!match) continue;
                method = curMethod;
                methodParameterTypes = curParameterTypes;
                break;
            }
            if (method != null) {
                String parametersString = StringUtil.merge(parameters);
                _log.error(StringBundler.concat("Obscure method name for class ", clazz, ", method ", methodName, ", and parameters ", parametersString));
                return null;
            }
            method = curMethod;
            methodParameterTypes = curParameterTypes;
        }
        if (method != null) {
            methodAndParameterTypes = new Object[]{method, methodParameterTypes};
            this._methodCache.put(key, methodAndParameterTypes);
            return methodAndParameterTypes;
        }
        String parametersString = StringUtil.merge(parameters);
        _log.error(StringBundler.concat("No method found for class ", clazz, ", method ", methodName, ", and parameters ", parametersString));
        return null;
    }

    @Override
    protected String getReroutePath() {
        return _REROUTE_PATH;
    }

    protected String getReturnValue(Object returnObj) throws Exception {
        if (returnObj instanceof JSONSerializable) {
            JSONSerializable jsonSerializable = (JSONSerializable)returnObj;
            return jsonSerializable.toJSONString();
        }
        JSONSerializer jsonSerializer = JSONFactoryUtil.createJSONSerializer();
        jsonSerializer.exclude("*.class");
        return jsonSerializer.serializeDeep(returnObj);
    }

    protected String[] getStringArrayFromJSON(HttpServletRequest httpServletRequest, String param) throws JSONException {
        String json = ParamUtil.getString(httpServletRequest, param, "[]");
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray(json);
        return ArrayUtil.toStringArray(jsonArray);
    }

    protected String getTypeNameOrClassDescriptor(Type type) {
        String typeName = type.toString();
        if (typeName.contains("class ")) {
            return typeName.substring(6);
        }
        Matcher matcher = _fieldDescriptorPattern.matcher(typeName);
        if (matcher.find()) {
            String dimensions = matcher.group(2);
            String fieldDescriptor = matcher.group(1);
            if (Validator.isNull(dimensions)) {
                return fieldDescriptor;
            }
            dimensions = dimensions.replace("]", "");
            fieldDescriptor = fieldDescriptor.equals("boolean") ? "Z" : (fieldDescriptor.equals("byte") ? "B" : (fieldDescriptor.equals("char") ? "C" : (fieldDescriptor.equals("double") ? "D" : (fieldDescriptor.equals("float") ? "F" : (fieldDescriptor.equals("int") ? "I" : (fieldDescriptor.equals("long") ? "J" : (fieldDescriptor.equals("short") ? "S" : "L".concat(fieldDescriptor).concat(";"))))))));
            return dimensions.concat(fieldDescriptor);
        }
        throw new IllegalArgumentException(type.toString() + " is invalid");
    }

    protected boolean isValidRequest(HttpServletRequest httpServletRequest) {
        String className = ParamUtil.getString(httpServletRequest, "serviceClassName");
        String methodName = ParamUtil.getString(httpServletRequest, "serviceMethodName");
        return className.contains(".service.") && className.endsWith("ServiceUtil") && !className.endsWith("LocalServiceUtil") && !this._invalidClassNames.contains(className) && !this._invalidMethodNames.contains(methodName);
    }
}

