/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.salesforce.client;

import com.liferay.petra.salesforce.client.SalesforceClient;
import com.sforce.async.AsyncApiException;
import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.GetUserInfoResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.SessionRenewer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSalesforceClientImpl
implements SalesforceClient {
    private static final int _SALESFORCE_CONNECTION_RETRY_COUNT = 3;
    private static final Logger _logger = LoggerFactory.getLogger(BaseSalesforceClientImpl.class);
    private String _authEndpoint;
    private int _connectionTimeout = 1;
    private ConnectorConfig _connectorConfig;
    private boolean _debugEnabled;
    private PartnerConnection _partnerConnection;
    private String _password;
    private int _readTimeout = 1;
    private String _serviceEndpoint;
    private String _sessionId;
    private String _userName;

    @Override
    public String getAuthEndpoint() {
        return this._authEndpoint;
    }

    @Override
    public int getConnectionTimeout() {
        return this._connectionTimeout;
    }

    @Override
    public ConnectorConfig getConnectorConfig() {
        if (this._connectorConfig == null) {
            this.afterPropertiesSet();
        }
        return this._connectorConfig;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public int getReadTimeout() {
        return this._readTimeout;
    }

    @Override
    public String getServiceEndpoint() {
        return this._serviceEndpoint;
    }

    @Override
    public String getSessionId() {
        return this._sessionId;
    }

    @Override
    public String getUserName() {
        return this._userName;
    }

    @Override
    public boolean isDebugEnabled() {
        return this._debugEnabled;
    }

    @Override
    public void setAuthEndpoint(String authEndpoint) {
        this._authEndpoint = authEndpoint;
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        this._connectionTimeout = connectionTimeout;
    }

    @Override
    public void setDebugEnabled(boolean debugEnabled) {
        this._debugEnabled = debugEnabled;
    }

    @Override
    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this._readTimeout = readTimeout;
    }

    @Override
    public void setServiceEndpoint(String serviceEndpoint) {
        this._serviceEndpoint = serviceEndpoint;
    }

    @Override
    public void setSessionId(String sessionId) {
        this._sessionId = sessionId;
    }

    @Override
    public void setUserName(String userName) {
        this._userName = userName;
    }

    protected void afterPropertiesSet() {
        this._connectorConfig = new ConnectorConfig();
        this._connectorConfig.setAuthEndpoint(this._authEndpoint);
        this._connectorConfig.setConnectionTimeout(this._connectionTimeout * 60000);
        this._connectorConfig.setReadTimeout(this._readTimeout * 60000);
        this._connectorConfig.setSessionRenewer(new SalesforceSessionRenewer());
        if (!Objects.isNull(this._sessionId)) {
            this._connectorConfig.setServiceEndpoint(this._serviceEndpoint);
            this._connectorConfig.setSessionId(this._sessionId);
        } else {
            this._connectorConfig.setPassword(this._password);
            this._connectorConfig.setUsername(this._userName);
        }
        if (this._debugEnabled) {
            Path filePath;
            this._connectorConfig.setPrettyPrintXml(true);
            this._connectorConfig.setTraceMessage(true);
            String baseDirName = System.getProperty("default.liferay.home");
            if (baseDirName == null) {
                baseDirName = System.getProperty("user.dir");
            }
            String filePathName = baseDirName + "/logs/salesforce.log";
            if (_logger.isInfoEnabled()) {
                _logger.info("Salesforce log file: {}", (Object)filePathName);
            }
            if (!Files.exists(filePath = Paths.get(filePathName, new String[0]), new LinkOption[0])) {
                try {
                    Path parentFilePath = filePath.getParent();
                    if (!Files.exists(parentFilePath, new LinkOption[0])) {
                        Files.createDirectories(parentFilePath, new FileAttribute[0]);
                    }
                    Files.createFile(filePath, new FileAttribute[0]);
                }
                catch (IOException ioe) {
                    _logger.error("Unable to create log file", ioe);
                }
            }
            try {
                this._connectorConfig.setTraceFile(filePathName);
            }
            catch (FileNotFoundException fnfe) {
                _logger.error("File not found", fnfe);
            }
        }
    }

    protected PartnerConnection getPartnerConnection() throws ConnectionException {
        return this._getPartnerConnection(false);
    }

    protected int getRetryCount(int retryCount, AsyncApiException asyncApiException) throws AsyncApiException {
        if (retryCount <= 0) {
            throw asyncApiException;
        }
        return this._getRetryCount(retryCount);
    }

    protected int getRetryCount(int retryCount, ConnectionException connectionException) throws ConnectionException {
        if (retryCount <= 0) {
            throw connectionException;
        }
        return this._getRetryCount(retryCount);
    }

    private PartnerConnection _getPartnerConnection(boolean newConnection) throws ConnectionException {
        if (!newConnection && this._partnerConnection != null) {
            block11: {
                try {
                    GetUserInfoResult userInfoResult = this._partnerConnection.getUserInfo();
                    int sessionSecondsValid = userInfoResult.getSessionSecondsValid();
                    if (sessionSecondsValid > 120) {
                        return this._partnerConnection;
                    }
                    if (_logger.isInfoEnabled()) {
                        _logger.info("Renewing session expiring in {} seconds", (Object)sessionSecondsValid);
                    }
                }
                catch (ConnectionException ce) {
                    if (!_logger.isInfoEnabled()) break block11;
                    _logger.info("Session has expired and will be renewed now");
                }
            }
            this._connectorConfig = null;
        }
        ConnectorConfig connectorConfig = this.getConnectorConfig();
        try {
            this._partnerConnection = Connector.newConnection(connectorConfig);
            return this._partnerConnection;
        }
        catch (ConnectionException ce1) {
            for (int i = 0; i < 3; ++i) {
                if (_logger.isInfoEnabled()) {
                    _logger.info("Retrying new connection: {}", (Object)(i + 1));
                }
                try {
                    this._partnerConnection = Connector.newConnection(connectorConfig);
                    return this._partnerConnection;
                }
                catch (ConnectionException ce2) {
                    if (i + 1 < 3) continue;
                    throw ce2;
                }
            }
            throw ce1;
        }
    }

    private int _getRetryCount(int retryCount) {
        --retryCount;
        if (_logger.isInfoEnabled()) {
            Thread thread = Thread.currentThread();
            StackTraceElement stackTraceElement = thread.getStackTrace()[3];
            _logger.info("Retrying: {} ({})", (Object)stackTraceElement.getMethodName(), (Object)retryCount);
        }
        return retryCount;
    }

    private class SalesforceSessionRenewer
    implements SessionRenewer {
        private SalesforceSessionRenewer() {
        }

        @Override
        public SessionRenewer.SessionRenewalHeader renewSession(ConnectorConfig connectorConfig) throws ConnectionException {
            BaseSalesforceClientImpl.this._partnerConnection = BaseSalesforceClientImpl.this._getPartnerConnection(true);
            SessionRenewer.SessionRenewalHeader sessionRenewalHeader = new SessionRenewer.SessionRenewalHeader();
            sessionRenewalHeader.headerElement = BaseSalesforceClientImpl.this._partnerConnection.getSessionHeader();
            sessionRenewalHeader.name = new QName("urn:partner.soap.sforce.com", "SessionHeader");
            return sessionRenewalHeader;
        }
    }
}

