/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.function.Consumer;

public class ReflectionUtil {
    private static final Method _cloneMethod;
    private static final Field _modifiersField;

    public static Object arrayClone(Object array) {
        Class<?> clazz = array.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("Input object is not an array: " + array);
        }
        try {
            return _cloneMethod.invoke(array, new Object[0]);
        }
        catch (Exception e) {
            return ReflectionUtil.throwException(e);
        }
    }

    public static Field getDeclaredField(Class<?> clazz, String name) throws Exception {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return ReflectionUtil.unfinalField(field);
    }

    public static Field[] getDeclaredFields(Class<?> clazz) throws Exception {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            ReflectionUtil.unfinalField(field);
        }
        return fields;
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        Method method = clazz.getDeclaredMethod(name, parameterTypes);
        method.setAccessible(true);
        return method;
    }

    public static Class<?>[] getInterfaces(Object object) {
        return ReflectionUtil.getInterfaces(object, null);
    }

    public static Class<?>[] getInterfaces(Object object, ClassLoader classLoader) {
        return ReflectionUtil.getInterfaces(object, classLoader, cnfe -> {});
    }

    public static Class<?>[] getInterfaces(Object object, ClassLoader classLoader, Consumer<ClassNotFoundException> classNotFoundHandler) {
        LinkedHashSet interfaceClasses = new LinkedHashSet();
        for (Class<?> superClass = object.getClass(); superClass != null; superClass = superClass.getSuperclass()) {
            for (Class<?> interfaceClass : superClass.getInterfaces()) {
                try {
                    if (classLoader == null) {
                        interfaceClasses.add(interfaceClass);
                        continue;
                    }
                    interfaceClasses.add(classLoader.loadClass(interfaceClass.getName()));
                }
                catch (ClassNotFoundException cnfe) {
                    classNotFoundHandler.accept(cnfe);
                }
            }
        }
        return interfaceClasses.toArray(new Class[0]);
    }

    public static <T> T throwException(Throwable throwable) {
        return ReflectionUtil._throwException(throwable);
    }

    public static Field unfinalField(Field field) throws Exception {
        int modifiers = field.getModifiers();
        if ((modifiers & 0x10) == 16) {
            _modifiersField.setInt(field, modifiers & 0xFFFFFFEF);
        }
        return field;
    }

    private static <T, E extends Throwable> T _throwException(Throwable throwable) throws E {
        throw throwable;
    }

    static {
        try {
            _cloneMethod = Object.class.getDeclaredMethod("clone", new Class[0]);
            _cloneMethod.setAccessible(true);
            _modifiersField = Field.class.getDeclaredField("modifiers");
            _modifiersField.setAccessible(true);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

