/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class AnnotationLocator {
    public static Map<Class<? extends Annotation>, Annotation> index(Class<?> targetClass) {
        LinkedList queue = new LinkedList();
        queue.offer(targetClass);
        LinkedHashMap<Class<? extends Annotation>, Annotation> indexMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        Class clazz = null;
        while ((clazz = (Class)queue.poll()) != null) {
            Annotation[] annotations = clazz.getAnnotations();
            AnnotationLocator._mergeAnnotations(annotations, indexMap);
            AnnotationLocator._queueSuperTypes(queue, clazz);
        }
        return indexMap;
    }

    public static Map<Class<? extends Annotation>, Annotation> index(Method method, Class<?> targetClass) {
        LinkedList queue = new LinkedList();
        if (targetClass == null) {
            queue.offer(method.getDeclaringClass());
        } else {
            queue.offer(targetClass);
        }
        LinkedHashMap<Class<? extends Annotation>, Annotation> indexMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        Class clazz = null;
        while ((clazz = (Class)queue.poll()) != null) {
            try {
                Method specificMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                Annotation[] annotations = specificMethod.getAnnotations();
                AnnotationLocator._mergeAnnotations(annotations, indexMap);
            }
            catch (Exception specificMethod) {
                // empty catch block
            }
            try {
                clazz.getMethod(method.getName(), method.getParameterTypes());
                Annotation[] annotations = clazz.getAnnotations();
                AnnotationLocator._mergeAnnotations(annotations, indexMap);
            }
            catch (Exception exception) {
                // empty catch block
            }
            AnnotationLocator._queueSuperTypes(queue, clazz);
        }
        return indexMap;
    }

    public static List<Annotation> locate(Class<?> targetClass) {
        Map<Class<? extends Annotation>, Annotation> indexMap = AnnotationLocator.index(targetClass);
        return new ArrayList<Annotation>(indexMap.values());
    }

    public static <T extends Annotation> T locate(Class<?> targetClass, Class<T> annotationClass) {
        LinkedList queue = new LinkedList();
        queue.offer(targetClass);
        Class clazz = null;
        while ((clazz = (Class)queue.poll()) != null) {
            T annotation = clazz.getAnnotation(annotationClass);
            if (annotation == null) {
                AnnotationLocator._queueSuperTypes(queue, clazz);
                continue;
            }
            return annotation;
        }
        return null;
    }

    public static List<Annotation> locate(Method method, Class<?> targetClass) {
        Map<Class<? extends Annotation>, Annotation> indexMap = AnnotationLocator.index(method, targetClass);
        return new ArrayList<Annotation>(indexMap.values());
    }

    public static <T extends Annotation> T locate(Method method, Class<?> targetClass, Class<T> annotationClass) {
        LinkedList queue = new LinkedList();
        if (targetClass == null) {
            queue.offer(method.getDeclaringClass());
        } else {
            queue.offer(targetClass);
        }
        Class clazz = null;
        while ((clazz = (Class)queue.poll()) != null) {
            T annotation = null;
            try {
                Method specificMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                annotation = specificMethod.getAnnotation(annotationClass);
                if (annotation != null) {
                    return annotation;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                clazz.getMethod(method.getName(), method.getParameterTypes());
                annotation = clazz.getAnnotation(annotationClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (annotation == null) {
                AnnotationLocator._queueSuperTypes(queue, clazz);
                continue;
            }
            return annotation;
        }
        return null;
    }

    private static void _mergeAnnotations(Annotation[] sourceAnnotations, Map<Class<? extends Annotation>, Annotation> indexMap) {
        for (Annotation sourceAnnotation : sourceAnnotations) {
            indexMap.putIfAbsent(sourceAnnotation.annotationType(), sourceAnnotation);
        }
    }

    private static void _queueSuperTypes(Queue<Class<?>> queue, Class<?> clazz) {
        Class<?>[] interfaceClasses;
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            queue.offer(superClass);
        }
        for (Class<?> interfaceClass : interfaceClasses = clazz.getInterfaces()) {
            if (queue.contains(interfaceClass)) continue;
            queue.offer(interfaceClass);
        }
    }
}

