/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.memory;

import com.liferay.petra.memory.EqualityPhantomReference;
import com.liferay.petra.memory.EqualitySoftReference;
import com.liferay.petra.memory.EqualityWeakReference;
import com.liferay.petra.memory.FinalizeAction;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FinalizeManager {
    public static final ReferenceFactory PHANTOM_REFERENCE_FACTORY = new ReferenceFactory(){

        @Override
        public <T> Reference<T> createReference(T reference, ReferenceQueue<? super T> referenceQueue) {
            return new EqualityPhantomReference<T>(reference, referenceQueue){

                @Override
                public void clear() {
                    _finalizeActions.remove(new IdentityKey(this));
                    super.clear();
                }
            };
        }
    };
    public static final ReferenceFactory SOFT_REFERENCE_FACTORY = new ReferenceFactory(){

        @Override
        public <T> Reference<T> createReference(T reference, ReferenceQueue<? super T> referenceQueue) {
            return new EqualitySoftReference<T>(reference, referenceQueue){

                @Override
                public void clear() {
                    _finalizeActions.remove(new IdentityKey(this));
                    super.clear();
                }
            };
        }
    };
    @Deprecated
    public static final boolean THREAD_ENABLED = true;
    public static final ReferenceFactory WEAK_REFERENCE_FACTORY = new ReferenceFactory(){

        @Override
        public <T> Reference<T> createReference(T reference, ReferenceQueue<? super T> referenceQueue) {
            return new EqualityWeakReference<T>(reference, referenceQueue){

                @Override
                public void clear() {
                    _finalizeActions.remove(new IdentityKey(this));
                    super.clear();
                }
            };
        }
    };
    private static final Map<IdentityKey, FinalizeAction> _finalizeActions = new ConcurrentHashMap<IdentityKey, FinalizeAction>();
    private static final ReferenceQueue<Object> _referenceQueue = new ReferenceQueue();

    public static <T> Reference<T> register(T reference, FinalizeAction finalizeAction, ReferenceFactory referenceFactory) {
        Reference<Object> newReference = referenceFactory.createReference(reference, _referenceQueue);
        _finalizeActions.put(new IdentityKey(newReference), finalizeAction);
        return newReference;
    }

    static /* synthetic */ ReferenceQueue access$200() {
        return _referenceQueue;
    }

    static {
        FinalizeThread thread = new FinalizeThread("Finalize Thread");
        thread.setContextClassLoader(FinalizeManager.class.getClassLoader());
        thread.setDaemon(true);
        thread.start();
    }

    private static class IdentityKey {
        private final Reference<?> _reference;

        public boolean equals(Object obj) {
            IdentityKey identityKey = (IdentityKey)obj;
            return this._reference == identityKey._reference;
        }

        public int hashCode() {
            return this._reference.hashCode();
        }

        private IdentityKey(Reference<?> reference) {
            this._reference = reference;
        }
    }

    private static class FinalizeThread
    extends Thread {
        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        reference = FinalizeManager.access$200().remove();
                        finalizeAction = (FinalizeAction)FinalizeManager.access$100().remove(new IdentityKey(reference));
                        if (finalizeAction == null) continue;
                        try {
                            finalizeAction.doFinalize(reference);
                        }
                        finally {
                            reference.clear();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException var1_2) {
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }

        private FinalizeThread(String name) {
            super(name);
        }
    }

    public static interface ReferenceFactory {
        public <T> Reference<T> createReference(T var1, ReferenceQueue<? super T> var2);
    }
}

