/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.mail;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.validator.routines.EmailValidator;

public class InternetAddressUtil {
    public static boolean contains(InternetAddress[] internetAddresses, String emailAddress) {
        if (internetAddresses != null && Validator.isNotNull(emailAddress)) {
            for (InternetAddress internetAddress : internetAddresses) {
                if (!emailAddress.equals(internetAddress.getAddress())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValid(String emailAddress) {
        EmailValidator emailValidator = EmailValidator.getInstance();
        return emailValidator.isValid(emailAddress);
    }

    public static InternetAddress[] removeEntry(Address[] addresses, String emailAddress) {
        InternetAddress[] internetAddresses = (InternetAddress[])addresses;
        if (internetAddresses == null || Validator.isNull(emailAddress)) {
            return internetAddresses;
        }
        ArrayList<InternetAddress> list = new ArrayList<InternetAddress>();
        for (InternetAddress internetAddress : internetAddresses) {
            if (emailAddress.equals(internetAddress.getAddress())) continue;
            list.add(internetAddress);
        }
        return list.toArray(new InternetAddress[0]);
    }

    public static String toString(Address address) {
        InternetAddress internetAddress = (InternetAddress)address;
        if (internetAddress != null) {
            StringBundler sb = new StringBundler(5);
            String personal = internetAddress.getPersonal();
            String emailAddress = internetAddress.getAddress();
            if (Validator.isNotNull(personal)) {
                sb.append(personal);
                sb.append(" ");
                sb.append("<");
                sb.append(emailAddress);
                sb.append(">");
            } else {
                sb.append(emailAddress);
            }
            return sb.toString();
        }
        return "";
    }

    public static String toString(Address[] addresses) {
        if (ArrayUtil.isEmpty(addresses)) {
            return "";
        }
        StringBundler sb = new StringBundler(addresses.length * 2 - 1);
        for (int i = 0; i < addresses.length - 1; ++i) {
            sb.append(InternetAddressUtil.toString(addresses[i]));
            sb.append(",");
        }
        sb.append(InternetAddressUtil.toString(addresses[addresses.length - 1]));
        return sb.toString();
    }

    public static void validateAddress(Address address) throws AddressException {
        if (address == null) {
            throw new AddressException("Email address is null");
        }
        String addressString = address.toString();
        for (char c : addressString.toCharArray()) {
            if (c != '\n' && c != '\r') continue;
            StringBundler sb = new StringBundler(3);
            sb.append("Email address ");
            sb.append(addressString);
            sb.append(" is invalid because it contains line breaks");
            throw new AddressException(sb.toString());
        }
    }

    public static void validateAddresses(Address[] addresses) throws AddressException {
        if (addresses == null) {
            throw new AddressException();
        }
        for (Address internetAddress : addresses) {
            InternetAddressUtil.validateAddress(internetAddress);
        }
    }
}

