/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.lang;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;

public class CentralizedThreadLocal<T>
extends ThreadLocal<T> {
    private static final int _HASH_INCREMENT = 1640531527;
    private static final Set<Class<?>> _immutableTypes = new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class));
    private static final AtomicInteger _longLivedNextHasCode = new AtomicInteger();
    private static final ThreadLocal<ThreadLocalMap> _longLivedThreadLocals = ThreadLocal.withInitial(() -> new ThreadLocalMap());
    private static final AtomicInteger _shortLivedNextHasCode = new AtomicInteger();
    private static final ThreadLocal<ThreadLocalMap> _shortLivedThreadLocals = ThreadLocal.withInitial(() -> new ThreadLocalMap());
    private final Function<T, T> _copyFunction;
    private final int _hashCode;
    private final String _name;
    private final boolean _shortLived;
    private final Supplier<T> _supplier;

    public static void clearLongLivedThreadLocals() {
        _longLivedThreadLocals.remove();
    }

    public static void clearShortLivedThreadLocals() {
        _shortLivedThreadLocals.remove();
    }

    public static Map<CentralizedThreadLocal<?>, Object> getLongLivedThreadLocals() {
        return CentralizedThreadLocal._toMap(_longLivedThreadLocals.get());
    }

    public static Map<CentralizedThreadLocal<?>, Object> getShortLivedThreadLocals() {
        return CentralizedThreadLocal._toMap(_shortLivedThreadLocals.get());
    }

    public static void setThreadLocals(Map<CentralizedThreadLocal<?>, Object> longLivedCentralizedThreadLocals, Map<CentralizedThreadLocal<?>, Object> shortLivedCentralizedThreadLocals) {
        ThreadLocalMap threadLocalMap = _longLivedThreadLocals.get();
        for (Map.Entry<CentralizedThreadLocal<?>, Object> entry : longLivedCentralizedThreadLocals.entrySet()) {
            threadLocalMap.putEntry(entry.getKey(), entry.getValue());
        }
        threadLocalMap = _shortLivedThreadLocals.get();
        for (Map.Entry<CentralizedThreadLocal<?>, Object> entry : shortLivedCentralizedThreadLocals.entrySet()) {
            threadLocalMap.putEntry(entry.getKey(), entry.getValue());
        }
    }

    public CentralizedThreadLocal(boolean shortLived) {
        this(null, () -> null, shortLived);
    }

    public CentralizedThreadLocal(String name) {
        this(name, () -> null, true);
    }

    public CentralizedThreadLocal(String name, Supplier<T> supplier) {
        this(name, supplier, true);
    }

    public CentralizedThreadLocal(String name, Supplier<T> supplier, boolean shortLived) {
        this(name, supplier, null, shortLived);
    }

    public CentralizedThreadLocal(String name, Supplier<T> supplier, Function<T, T> copyFunction, boolean shortLived) {
        this._hashCode = shortLived ? _shortLivedNextHasCode.getAndAdd(1640531527) : _longLivedNextHasCode.getAndAdd(1640531527);
        this._name = name == null ? super.toString() : name;
        this._supplier = supplier == null ? () -> null : supplier;
        this._copyFunction = copyFunction == null ? this::_copy : copyFunction;
        this._shortLived = shortLived;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public T get() {
        ThreadLocalMap threadLocalMap = this._getThreadLocalMap();
        Entry entry = threadLocalMap.getEntry(this);
        if (entry == null) {
            T value = this.initialValue();
            threadLocalMap.putEntry(this, value);
            return value;
        }
        return (T)entry._value;
    }

    public int hashCode() {
        return this._hashCode;
    }

    @Override
    public void remove() {
        ThreadLocalMap threadLocalMap = this._getThreadLocalMap();
        threadLocalMap.removeEntry(this);
    }

    @Override
    public void set(T value) {
        ThreadLocalMap threadLocalMap = this._getThreadLocalMap();
        threadLocalMap.putEntry(this, value);
    }

    public String toString() {
        return this._name;
    }

    @Override
    protected T initialValue() {
        return this._supplier.get();
    }

    private static Map<CentralizedThreadLocal<?>, Object> _toMap(ThreadLocalMap threadLocalMap) {
        HashMap map = new HashMap(threadLocalMap._table.length);
        for (Entry entry : threadLocalMap._table) {
            while (entry != null) {
                CentralizedThreadLocal centralizedThreadLocal = entry._key;
                Object value = centralizedThreadLocal._copyFunction.apply(entry._value);
                if (value != null) {
                    map.put(centralizedThreadLocal, value);
                }
                entry = entry._next;
            }
        }
        return map;
    }

    private T _copy(T value) {
        Class<?> clazz;
        if (value != null && _immutableTypes.contains(clazz = value.getClass())) {
            return value;
        }
        return null;
    }

    private ThreadLocalMap _getThreadLocalMap() {
        if (this._shortLived) {
            return _shortLivedThreadLocals.get();
        }
        return _longLivedThreadLocals.get();
    }

    private static class ThreadLocalMap {
        private static final int _INITIAL_CAPACITY = 16;
        private static final int _MAXIMUM_CAPACITY = 0x40000000;
        private int _size;
        private Entry[] _table = new Entry[16];
        private int _threshold = 10;

        private ThreadLocalMap() {
        }

        public void expand(int newCapacity) {
            if (newCapacity == Integer.MIN_VALUE) {
                this._threshold = Integer.MAX_VALUE;
                return;
            }
            Entry[] newTable = new Entry[newCapacity];
            for (int i = 0; i < this._table.length; ++i) {
                Entry nextEntry;
                Entry entry = this._table[i];
                if (entry == null) continue;
                this._table[i] = null;
                do {
                    nextEntry = entry._next;
                    int index = ((CentralizedThreadLocal)entry._key)._hashCode & newCapacity - 1;
                    entry._next = newTable[index];
                    newTable[index] = entry;
                } while ((entry = nextEntry) != null);
            }
            this._table = newTable;
            this._threshold = newCapacity * 2 / 3;
        }

        public Entry getEntry(CentralizedThreadLocal<?> key) {
            int index = ((CentralizedThreadLocal)key)._hashCode & this._table.length - 1;
            Entry entry = this._table[index];
            if (entry == null) {
                return null;
            }
            if (entry._key == key) {
                return entry;
            }
            while ((entry = entry._next) != null) {
                if (entry._key != key) continue;
                return entry;
            }
            return null;
        }

        public void putEntry(CentralizedThreadLocal<?> key, Object value) {
            int index = ((CentralizedThreadLocal)key)._hashCode & this._table.length - 1;
            Entry entry = this._table[index];
            while (entry != null) {
                if (entry._key == key) {
                    entry._value = value;
                    return;
                }
                entry = entry._next;
            }
            this._table[index] = new Entry(key, value, this._table[index]);
            if (this._size++ >= this._threshold) {
                this.expand(2 * this._table.length);
            }
        }

        public void removeEntry(CentralizedThreadLocal<?> key) {
            int index = ((CentralizedThreadLocal)key)._hashCode & this._table.length - 1;
            Entry previousEntry = null;
            Entry entry = this._table[index];
            while (entry != null) {
                Entry nextEntry = entry._next;
                if (entry._key == key) {
                    --this._size;
                    if (previousEntry == null) {
                        this._table[index] = nextEntry;
                    } else {
                        previousEntry._next = nextEntry;
                    }
                    return;
                }
                previousEntry = entry;
                entry = nextEntry;
            }
        }
    }

    private static class Entry {
        private CentralizedThreadLocal<?> _key;
        private Entry _next;
        private Object _value;

        public Entry(CentralizedThreadLocal<?> key, Object value, Entry next) {
            this._key = key;
            this._value = value;
            this._next = next;
        }
    }
}

