/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.json.web.service.client.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpClient
implements Closeable {
    private static final Logger _logger = LoggerFactory.getLogger(AsyncHttpClient.class);
    private final CloseableHttpAsyncClient _closeableHttpAsyncClient;
    private final int _maxAttempts;

    public AsyncHttpClient(CloseableHttpAsyncClient closeableHttpAsyncClient, int maxAttempts) {
        this._closeableHttpAsyncClient = closeableHttpAsyncClient;
        this._maxAttempts = maxAttempts < 1 ? 1 : maxAttempts;
    }

    @Override
    public void close() throws IOException {
        this._closeableHttpAsyncClient.close();
    }

    public Future<HttpResponse> execute(HttpHost httpHost, HttpRequest httpRequest) {
        return this.execute(httpHost, httpRequest, HttpClientContext.create());
    }

    public Future<HttpResponse> execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        for (int i = 1; i <= this._maxAttempts; ++i) {
            if (this._maxAttempts == 1 || this._maxAttempts == i) {
                return this._closeableHttpAsyncClient.execute(httpHost, httpRequest, httpContext, null);
            }
            try {
                Future<HttpResponse> httpResponseFuture = this._closeableHttpAsyncClient.execute(httpHost, httpRequest, httpContext, null);
                httpResponseFuture.get();
                return httpResponseFuture;
            }
            catch (Exception e) {
                if (_logger.isTraceEnabled()) {
                    _logger.trace("Unable to execute HTTP request in attempt " + i, e);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    _logger.error("Interrupted", ie);
                    if (!_logger.isInfoEnabled()) continue;
                    _logger.info("Aborting executing after " + i + " attempts");
                }
                continue;
            }
        }
        throw new RuntimeException("Unable to execute HTTP request after " + this._maxAttempts + " attempts");
    }
}

