/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.io;

import com.liferay.petra.io.BigEndianCodec;
import com.liferay.petra.io.ProtectedAnnotatedObjectInputStream;
import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.petra.lang.ClassResolverUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class Deserializer {
    private final byte[] _buffer;
    private int _index;
    private final int _limit;

    public Deserializer(ByteBuffer byteBuffer) {
        this._buffer = byteBuffer.array();
        this._index = byteBuffer.arrayOffset();
        this._limit = this._index + byteBuffer.remaining();
    }

    public boolean readBoolean() {
        this._detectBufferUnderflow(1);
        return BigEndianCodec.getBoolean(this._buffer, this._index++);
    }

    public byte readByte() {
        this._detectBufferUnderflow(1);
        return this._buffer[this._index++];
    }

    public char readChar() {
        this._detectBufferUnderflow(2);
        char c = BigEndianCodec.getChar(this._buffer, this._index);
        this._index += 2;
        return c;
    }

    public double readDouble() {
        this._detectBufferUnderflow(8);
        double d = BigEndianCodec.getDouble(this._buffer, this._index);
        this._index += 8;
        return d;
    }

    public float readFloat() {
        this._detectBufferUnderflow(4);
        float f = BigEndianCodec.getFloat(this._buffer, this._index);
        this._index += 4;
        return f;
    }

    public int readInt() {
        this._detectBufferUnderflow(4);
        int i = BigEndianCodec.getInt(this._buffer, this._index);
        this._index += 4;
        return i;
    }

    public long readLong() {
        this._detectBufferUnderflow(8);
        long l = BigEndianCodec.getLong(this._buffer, this._index);
        this._index += 8;
        return l;
    }

    public <T extends Serializable> T readObject() throws ClassNotFoundException {
        byte tcByte;
        if ((tcByte = this._buffer[this._index++]) == 0) {
            return (T)Boolean.valueOf(this.readBoolean());
        }
        if (tcByte == 1) {
            return (T)Byte.valueOf(this.readByte());
        }
        if (tcByte == 2) {
            return (T)Character.valueOf(this.readChar());
        }
        if (tcByte == 3) {
            String contextName = this.readString();
            String className = this.readString();
            ClassLoader classLoader = ClassLoaderPool.getClassLoader(contextName);
            return (T)ClassResolverUtil.resolve(className, classLoader);
        }
        if (tcByte == 4) {
            return (T)Double.valueOf(this.readDouble());
        }
        if (tcByte == 5) {
            return (T)Float.valueOf(this.readFloat());
        }
        if (tcByte == 6) {
            return (T)Integer.valueOf(this.readInt());
        }
        if (tcByte == 7) {
            return (T)Long.valueOf(this.readLong());
        }
        if (tcByte == 8) {
            return null;
        }
        if (tcByte == 10) {
            return (T)Short.valueOf(this.readShort());
        }
        if (tcByte == 11) {
            return (T)this.readString();
        }
        if (tcByte == 9) {
            try {
                ProtectedAnnotatedObjectInputStream objectInputStream = new ProtectedAnnotatedObjectInputStream(new BufferInputStream());
                return (T)((Serializable)objectInputStream.readObject());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        throw new IllegalStateException("Unkown TC code " + tcByte);
    }

    public short readShort() {
        this._detectBufferUnderflow(2);
        short s = BigEndianCodec.getShort(this._buffer, this._index);
        this._index += 2;
        return s;
    }

    public String readString() {
        this._detectBufferUnderflow(5);
        boolean asciiCode = BigEndianCodec.getBoolean(this._buffer, this._index++);
        int length = BigEndianCodec.getInt(this._buffer, this._index);
        this._index += 4;
        if (asciiCode) {
            this._detectBufferUnderflow(length);
            String s = new String(this._buffer, this._index, length);
            this._index += length;
            return s;
        }
        this._detectBufferUnderflow(length <<= 1);
        ByteBuffer byteBuffer = ByteBuffer.wrap(this._buffer, this._index, length);
        this._index += length;
        CharBuffer charBuffer = byteBuffer.asCharBuffer();
        return charBuffer.toString();
    }

    private void _detectBufferUnderflow(int availableBytes) {
        if (this._index + availableBytes > this._limit) {
            throw new IllegalStateException("Buffer underflow");
        }
    }

    private class BufferInputStream
    extends InputStream {
        private BufferInputStream() {
        }

        @Override
        public int read() {
            return Deserializer.this._buffer[Deserializer.this._index++];
        }

        @Override
        public int read(byte[] bytes) {
            return this.read(bytes, 0, bytes.length);
        }

        @Override
        public int read(byte[] bytes, int offset, int length) {
            int remain = Deserializer.this._limit - Deserializer.this._index;
            if (remain < length) {
                length = remain;
            }
            System.arraycopy(Deserializer.this._buffer, Deserializer.this._index, bytes, offset, length);
            Deserializer.this._index = Deserializer.this._index + length;
            return length;
        }
    }
}

