/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.doulos.servlet;

import com.liferay.petra.doulos.processor.DoulosRequestProcessor;
import com.liferay.petra.string.StringBundler;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public abstract class DoulosServlet
extends HttpServlet {
    private static final Log _log = LogFactory.getLog(DoulosServlet.class);
    private final Map<String, DoulosRequestProcessor> _doulosRequestProcessors = new HashMap<String, DoulosRequestProcessor>();
    private String[] _validIps;

    public void destroy() {
        for (Map.Entry<String, DoulosRequestProcessor> entry : this._doulosRequestProcessors.entrySet()) {
            DoulosRequestProcessor doulosRequestProcessor = entry.getValue();
            try {
                doulosRequestProcessor.destroy();
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
        super.destroy();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.service(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.service(httpServletRequest, httpServletResponse);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            this.registerDoulosRequestProcessors();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        String validIpsString = servletConfig.getInitParameter("validIps");
        this._validIps = validIpsString != null ? validIpsString.split(",") : new String[0];
    }

    protected boolean isBlank(String s) {
        return s == null || s.equals("");
    }

    protected boolean isValidIP(String remoteAddr) {
        if (this._validIps.length == 0) {
            return true;
        }
        for (String validIp : this._validIps) {
            if (!remoteAddr.equals(validIp) && !remoteAddr.startsWith(validIp + ".")) continue;
            return true;
        }
        return false;
    }

    protected void registerDoulosRequestProcessor(String doulosRequestProcessorKey, DoulosRequestProcessor doulosRequestProcessor) {
        this._doulosRequestProcessors.put(doulosRequestProcessorKey, doulosRequestProcessor);
    }

    protected abstract void registerDoulosRequestProcessors() throws Exception;

    protected void sendError(HttpServletResponse httpServletResponse, String message) throws IOException {
        this.write(httpServletResponse, new ByteArrayInputStream(message.getBytes()));
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String remoteAddr = httpServletRequest.getRemoteAddr();
        if (_log.isInfoEnabled()) {
            _log.info("Remote address: " + remoteAddr);
        }
        if (!this.isValidIP(remoteAddr)) {
            this.sendError(httpServletResponse, "IP " + remoteAddr + " is invalid.");
            return;
        }
        String pathInfo = httpServletRequest.getPathInfo();
        if (pathInfo.length() > 1 && pathInfo.endsWith("/")) {
            pathInfo = pathInfo.substring(0, pathInfo.length() - 1);
        }
        for (Map.Entry<String, DoulosRequestProcessor> entry : this._doulosRequestProcessors.entrySet()) {
            String doulosRequestProcessorKey = entry.getKey();
            if (!pathInfo.startsWith(doulosRequestProcessorKey)) continue;
            DoulosRequestProcessor doulosRequestProcessor = entry.getValue();
            if (_log.isInfoEnabled()) {
                _log.info(StringBundler.concat("Processing ", httpServletRequest.getRequestURL(), " with ", doulosRequestProcessor));
            }
            try {
                String payload = httpServletRequest.getParameter("payload");
                if (_log.isInfoEnabled()) {
                    _log.info("Payload parameter: " + payload);
                }
                if (payload == null) {
                    StringBuilder sb = new StringBuilder();
                    String line = null;
                    BufferedReader bufferedReader = httpServletRequest.getReader();
                    while ((line = bufferedReader.readLine()) != null) {
                        sb.append(line);
                    }
                    bufferedReader.close();
                    payload = sb.toString();
                    if (_log.isInfoEnabled()) {
                        _log.info("Payload body: " + payload);
                    }
                }
                JSONObject payloadJSONObject = null;
                payloadJSONObject = payload.length() > 0 ? new JSONObject(payload) : new JSONObject();
                JSONObject responseJSONObject = new JSONObject();
                doulosRequestProcessor.process(httpServletRequest.getMethod(), pathInfo.substring(doulosRequestProcessorKey.length()), httpServletRequest.getParameterMap(), payloadJSONObject, responseJSONObject);
                String redirect = responseJSONObject.optString("doulosRedirect");
                if (!this.isBlank(redirect)) {
                    httpServletResponse.sendRedirect(redirect);
                    return;
                }
                String json = responseJSONObject.toString();
                this.write(httpServletResponse, new ByteArrayInputStream(json.getBytes("UTF-8")));
            }
            catch (Exception e) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                e.printStackTrace(printWriter);
                String output = stringWriter.toString();
                if (_log.isInfoEnabled()) {
                    _log.info(output);
                }
                this.sendError(httpServletResponse, output);
            }
            return;
        }
        this.sendError(httpServletResponse, "Unregistered path " + httpServletRequest.getPathInfo() + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(HttpServletResponse httpServletResponse, InputStream inputStream) throws IOException {
        OutputStream outputStream = null;
        try {
            httpServletResponse.setHeader("Cache-Control", "public");
            if (!httpServletResponse.isCommitted()) {
                outputStream = new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream());
                int c = inputStream.read();
                while (c != -1) {
                    outputStream.write(c);
                    c = inputStream.read();
                }
            }
        }
        finally {
            block23: {
                block22: {
                    block21: {
                        try {
                            if (outputStream != null) {
                                outputStream.flush();
                            }
                        }
                        catch (Exception e) {
                            if (!_log.isWarnEnabled()) break block21;
                            _log.warn(e, e);
                        }
                    }
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (Exception e) {
                        if (!_log.isWarnEnabled()) break block22;
                        _log.warn(e, e);
                    }
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block23;
                    _log.warn(e, e);
                }
            }
        }
    }
}

