/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.doulos.processor;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.liferay.petra.doulos.processor.BaseDoulosRequestProcessor;
import com.liferay.petra.string.StringBundler;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public abstract class BaseShellDoulosRequestProcessor
extends BaseDoulosRequestProcessor {
    private static final int _EXPIRED_TIME = 0;
    private static final long _SHELL_STATUSES_SIZE = 1000L;
    private static final int _THREAD_DESTROY_INTERVAL = 10000;
    private static final int _THREAD_EXECUTE_INTERVAL = 3000;
    private static final Log _log = LogFactory.getLog(BaseShellDoulosRequestProcessor.class);
    private boolean _destroy;
    private boolean _destroyed;
    private final Queue<ShellStatus> _queue = new LinkedBlockingQueue<ShellStatus>();
    private final Map<String, ShellStatus> _shellStatuses;
    private final Thread _thread = new Thread(){

        @Override
        public void run() {
            while (!BaseShellDoulosRequestProcessor.this._destroy) {
                ShellStatus shellStatus = (ShellStatus)BaseShellDoulosRequestProcessor.this._queue.poll();
                if (shellStatus == null) {
                    try {
                        Thread.sleep(BaseShellDoulosRequestProcessor.this.getThreadExecuteInterval());
                        continue;
                    }
                    catch (InterruptedException ie) {
                        _log.error("Terminating background thread due to unexpected interruption", ie);
                        break;
                    }
                }
                System.out.println("Queue size " + BaseShellDoulosRequestProcessor.this._queue.size());
                try {
                    if (_log.isInfoEnabled()) {
                        _log.info("Executing " + shellStatus.key);
                    }
                    BaseShellDoulosRequestProcessor.this.execute(shellStatus);
                }
                catch (Exception e) {
                    _log.error(e, e);
                }
            }
            BaseShellDoulosRequestProcessor.this._destroyed = true;
        }
    };

    public BaseShellDoulosRequestProcessor() {
        ConcurrentLinkedHashMap.Builder builder = new ConcurrentLinkedHashMap.Builder();
        builder.maximumWeightedCapacity(this.getShellStatusesSize());
        this._shellStatuses = builder.build();
        this._thread.start();
    }

    @Override
    public void destroy() {
        this._destroy = true;
        while (!this._destroyed) {
            try {
                if (_log.isInfoEnabled()) {
                    _log.info("Waiting for background thread to destroy");
                }
                Thread.sleep(this.getThreadDestroyInterval());
            }
            catch (InterruptedException ie) {
                _log.error(ie, ie);
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info("Background thread is destroyed");
        }
        super.destroy();
    }

    @Override
    public void process(String method, String pathInfo, Map<String, String[]> parameterMap, JSONObject payloadJSONObject, JSONObject responseJSONObject) throws Exception {
        if (!this.isValid(payloadJSONObject)) {
            if (_log.isInfoEnabled()) {
                _log.info("Skip invalid payload");
            }
            responseJSONObject.put("queue", new ArrayList<String>(this._shellStatuses.keySet()));
            return;
        }
        ShellStatus shellStatus = this.queue(payloadJSONObject);
        this.populateResponseJSONObject(responseJSONObject, shellStatus);
        responseJSONObject.put("queueSize", this._queue.size());
        if (_log.isInfoEnabled()) {
            _log.info(StringBundler.concat("Status ", shellStatus.status, " for ", shellStatus.key));
        }
    }

    protected void addShellStatus(String key, ShellStatus shellStatus) {
        this._shellStatuses.put(key, shellStatus);
        this._queue.add(shellStatus);
    }

    protected abstract ShellStatus createShellStatus(JSONObject var1);

    protected void execute(ShellStatus shellStatus) throws Exception {
        shellStatus.status = "executing";
        List<String> shellCommandsList = this.getShellCommands(shellStatus);
        shellCommandsList.add(0, "/bin/bash");
        shellCommandsList.add(1, "-x");
        shellCommandsList.add(2, "-c");
        Object[] shellCommands = shellCommandsList.toArray(new String[0]);
        shellStatus.shellCommands = StringUtils.join(shellCommands, "\n");
        ProcessBuilder processBuilder = new ProcessBuilder((String[])shellCommands);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        StringBuilder sb = new StringBuilder();
        String line = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = bufferedReader.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        bufferedReader.close();
        try {
            if (_log.isDebugEnabled()) {
                _log.debug("Wait for process to finish");
            }
            process.waitFor();
            shellStatus.exitValue = String.valueOf(process.exitValue());
            shellStatus.output = sb.toString();
            shellStatus.status = "finished";
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            e.printStackTrace(printWriter);
            shellStatus.exception = ((Object)writer).toString();
            shellStatus.status = "exception";
        }
    }

    protected long getExpiredTime() {
        return 0L;
    }

    protected abstract String getKey(JSONObject var1);

    protected abstract List<String> getShellCommands(ShellStatus var1);

    protected long getShellStatusesSize() {
        return 1000L;
    }

    protected int getThreadDestroyInterval() {
        return 10000;
    }

    protected int getThreadExecuteInterval() {
        return 3000;
    }

    protected abstract boolean isRemoveFromQueue(JSONObject var1);

    protected abstract boolean isValid(JSONObject var1);

    protected void populateResponseJSONObject(JSONObject responseJSONObject, ShellStatus shellStatus) {
        responseJSONObject.put("exception", (Object)shellStatus.exception);
        responseJSONObject.put("exitValue", (Object)shellStatus.exitValue);
        responseJSONObject.put("output", (Object)shellStatus.output);
        responseJSONObject.put("shellCommands", (Object)shellStatus.shellCommands);
        responseJSONObject.put("status", (Object)shellStatus.status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ShellStatus queue(JSONObject payloadJSONObject) {
        ShellStatus shellStatus = null;
        String key = this.getKey(payloadJSONObject);
        BaseShellDoulosRequestProcessor baseShellDoulosRequestProcessor = this;
        synchronized (baseShellDoulosRequestProcessor) {
            long expiredTime;
            shellStatus = this._shellStatuses.get(key);
            if (this.isRemoveFromQueue(payloadJSONObject)) {
                if (shellStatus != null) {
                    this.removeShellStatus(key, shellStatus);
                }
                shellStatus = this.createShellStatus(payloadJSONObject);
                shellStatus.status = "removed";
                return shellStatus;
            }
            if (shellStatus != null && (expiredTime = this.getExpiredTime()) > 0L && shellStatus.time < this.getExpiredTime()) {
                this.removeShellStatus(key, shellStatus);
                shellStatus = null;
            }
            if (shellStatus == null) {
                if (_log.isInfoEnabled()) {
                    _log.info("Adding " + key + " to queue");
                }
                shellStatus = this.createShellStatus(payloadJSONObject);
                this.addShellStatus(key, shellStatus);
            }
        }
        return shellStatus;
    }

    protected void removeShellStatus(String key, ShellStatus shellStatus) {
        this._shellStatuses.remove(key);
        this._queue.remove(shellStatus);
    }

    protected class ShellStatus {
        public String exception = "";
        public String exitValue = "";
        public String key = "";
        public String output = "";
        public String shellCommands = "";
        public String status = "queued";
        public long time = System.currentTimeMillis();

        public ShellStatus(String key) {
            this.key = key;
        }
    }
}

