/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.service.tracker.collections.map;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTrackerCustomizerFactory {
    public static <S, T> Function<BundleContext, ServiceTrackerCustomizer<S, T>> createFromFunction(BiFunction<ServiceReference<S>, S, T> function) {
        return b -> new ServiceTrackerCustomizer<S, T>((BundleContext)b, function){
            final /* synthetic */ BundleContext val$b;
            final /* synthetic */ BiFunction val$function;
            {
                this.val$b = bundleContext;
                this.val$function = biFunction;
            }

            public T addingService(ServiceReference<S> serviceReference) {
                Object service = this.val$b.getService(serviceReference);
                try {
                    return this.val$function.apply(serviceReference, service);
                }
                catch (Exception e) {
                    this.val$b.ungetService(serviceReference);
                    throw e;
                }
            }

            public void modifiedService(ServiceReference<S> serviceReference, T t) {
                this.removedService(serviceReference, t);
                this.addingService(serviceReference);
            }

            public void removedService(ServiceReference<S> serviceReference, T t) {
                this.val$b.ungetService(serviceReference);
            }
        };
    }

    public static <S> ServiceTrackerCustomizer<S, ServiceWrapper<S>> serviceWrapper(final BundleContext bundleContext) {
        return new ServiceTrackerCustomizer<S, ServiceWrapper<S>>(){

            public ServiceWrapper<S> addingService(ServiceReference<S> serviceReference) {
                final Object service = bundleContext.getService(serviceReference);
                if (service == null) {
                    return null;
                }
                try {
                    final Map properties = ServiceTrackerCustomizerFactory._getProperties(serviceReference);
                    return new ServiceWrapper<S>(){

                        @Override
                        public Map<String, Object> getProperties() {
                            return properties;
                        }

                        @Override
                        public S getService() {
                            return service;
                        }
                    };
                }
                catch (Throwable t) {
                    bundleContext.ungetService(serviceReference);
                    throw t;
                }
            }

            public void modifiedService(ServiceReference<S> serviceReference, ServiceWrapper<S> serviceWrapper) {
            }

            public void removedService(ServiceReference<S> serviceReference, ServiceWrapper<S> serviceWrapper) {
                bundleContext.ungetService(serviceReference);
            }
        };
    }

    private static <S> Map<String, Object> _getProperties(ServiceReference<S> serviceReference) {
        String[] propertyKeys;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String propertyKey : propertyKeys = serviceReference.getPropertyKeys()) {
            properties.put(propertyKey, serviceReference.getProperty(propertyKey));
        }
        return properties;
    }

    public static interface ServiceWrapper<S> {
        public Map<String, Object> getProperties();

        public S getService();
    }
}

