/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.settings;

import com.liferay.message.boards.util.MBUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.settings.FallbackKeys;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.ParameterMapSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.TypedSettings;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.rss.util.RSSUtil;
import java.util.Map;

@Settings.Config(settingsIds={"com.liferay.message.boards"})
public class MBGroupServiceSettings {
    public static final String[] ALL_KEYS = new String[0];
    private final TypedSettings _typedSettings;

    public static MBGroupServiceSettings getInstance(long groupId) throws PortalException {
        Settings settings = SettingsFactoryUtil.getSettings(new GroupServiceSettingsLocator(groupId, "com.liferay.message.boards"));
        return new MBGroupServiceSettings(settings);
    }

    public static MBGroupServiceSettings getInstance(long groupId, Map<String, String[]> parameterMap) throws PortalException {
        Settings settings = SettingsFactoryUtil.getSettings(new GroupServiceSettingsLocator(groupId, "com.liferay.message.boards"));
        ParameterMapSettings parameterMapSettings = new ParameterMapSettings(parameterMap, settings);
        return new MBGroupServiceSettings(parameterMapSettings);
    }

    public static void registerSettingsMetadata() {
        SettingsFactoryUtil.registerSettingsMetadata(MBGroupServiceSettings.class, null, MBGroupServiceSettings._getFallbackKeys());
    }

    public MBGroupServiceSettings(Settings settings) {
        this._typedSettings = new TypedSettings(settings);
    }

    public String getEmailFromAddress() {
        return this._typedSettings.getValue("emailFromAddress");
    }

    public String getEmailFromName() {
        return this._typedSettings.getValue("emailFromName");
    }

    public LocalizedValuesMap getEmailMessageAddedBody() {
        return this._typedSettings.getLocalizedValuesMap("emailMessageAddedBody");
    }

    public String getEmailMessageAddedBodyXml() {
        return LocalizationUtil.getXml(this.getEmailMessageAddedBody(), "emailMessageAddedBody");
    }

    public LocalizedValuesMap getEmailMessageAddedSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailMessageAddedSubject");
    }

    public String getEmailMessageAddedSubjectXml() {
        return LocalizationUtil.getXml(this.getEmailMessageAddedSubject(), "emailMessageAddedSubject");
    }

    public LocalizedValuesMap getEmailMessageUpdatedBody() {
        return this._typedSettings.getLocalizedValuesMap("emailMessageUpdatedBody");
    }

    public String getEmailMessageUpdatedBodyXml() {
        return LocalizationUtil.getXml(this.getEmailMessageUpdatedBody(), "emailMessageUpdatedBody");
    }

    public LocalizedValuesMap getEmailMessageUpdatedSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailMessageUpdatedSubject");
    }

    public String getEmailMessageUpdatedSubjectXml() {
        return LocalizationUtil.getXml(this.getEmailMessageUpdatedSubject(), "emailMessageUpdatedSubject");
    }

    public String getMessageFormat() {
        String messageFormat = this._typedSettings.getValue("messageFormat");
        if (MBUtil.isValidMessageFormat(messageFormat)) {
            return messageFormat;
        }
        return "html";
    }

    public String[] getPriorities(String currentLanguageId) {
        return LocalizationUtil.getSettingsValues(this._typedSettings.getWrappedSettings(), "priorities", currentLanguageId);
    }

    public String[] getRanks(String languageId) {
        return LocalizationUtil.getSettingsValues(this._typedSettings.getWrappedSettings(), "ranks", languageId);
    }

    public String getRecentPostsDateOffset() {
        return this._typedSettings.getValue("recentPostsDateOffset");
    }

    @Settings.Property(name="rssDelta")
    public int getRSSDelta() {
        return this._typedSettings.getIntegerValue("rssDelta");
    }

    @Settings.Property(name="rssDisplayStyle")
    public String getRSSDisplayStyle() {
        return this._typedSettings.getValue("rssDisplayStyle", "full-content");
    }

    @Settings.Property(name="rssFeedType")
    public String getRSSFeedType() {
        return this._typedSettings.getValue("rssFeedType", RSSUtil.getFeedType("atom", 1.0));
    }

    public boolean isAllowAnonymousPosting() {
        return this._typedSettings.getBooleanValue("allowAnonymousPosting");
    }

    public boolean isEmailHtmlFormat() {
        return this._typedSettings.getBooleanValue("emailHtmlFormat");
    }

    public boolean isEmailMessageAddedEnabled() {
        return this._typedSettings.getBooleanValue("emailMessageAddedEnabled");
    }

    public boolean isEmailMessageUpdatedEnabled() {
        return this._typedSettings.getBooleanValue("emailMessageUpdatedEnabled");
    }

    public boolean isEnableFlags() {
        return this._typedSettings.getBooleanValue("enableFlags");
    }

    public boolean isEnableRatings() {
        return this._typedSettings.getBooleanValue("enableRatings");
    }

    @Settings.Property(name="enableRss")
    public boolean isEnableRSS() {
        if (!PortalUtil.isRSSFeedsEnabled()) {
            return false;
        }
        return this._typedSettings.getBooleanValue("enableRss");
    }

    public boolean isSubscribeByDefault() {
        return this._typedSettings.getBooleanValue("subscribeByDefault");
    }

    public boolean isThreadAsQuestionByDefault() {
        return this._typedSettings.getBooleanValue("threadAsQuestionByDefault");
    }

    private static FallbackKeys _getFallbackKeys() {
        FallbackKeys fallbackKeys = new FallbackKeys();
        fallbackKeys.add("allowAnonymousPosting", "message.boards.anonymous.posting.enabled");
        fallbackKeys.add("emailFromAddress", "message.boards.email.from.address", "admin.email.from.address");
        fallbackKeys.add("emailFromName", "message.boards.email.from.name", "admin.email.from.name");
        fallbackKeys.add("emailHtmlFormat", "message.boards.email.html.format");
        fallbackKeys.add("emailMessageAddedBody", "message.boards.email.message.added.body");
        fallbackKeys.add("emailMessageAddedEnabled", "message.boards.email.message.added.enabled");
        fallbackKeys.add("emailMessageAddedSubject", "message.boards.email.message.added.subject");
        fallbackKeys.add("emailMessageUpdatedBody", "message.boards.email.message.updated.body");
        fallbackKeys.add("emailMessageUpdatedEnabled", "message.boards.email.message.updated.enabled");
        fallbackKeys.add("emailMessageUpdatedSubject", "message.boards.email.message.updated.subject");
        fallbackKeys.add("enableFlags", "message.boards.flags.enabled");
        fallbackKeys.add("enableRatings", "message.boards.ratings.enabled");
        fallbackKeys.add("enableRss", "message.boards.rss.enabled");
        fallbackKeys.add("messageFormat", "message.boards.message.formats.default");
        fallbackKeys.add("priorities", "message.boards.thread.priorities");
        fallbackKeys.add("ranks", "message.boards.user.ranks");
        fallbackKeys.add("recentPostsDateOffset", "message.boards.recent.posts.date.offset");
        fallbackKeys.add("rssDelta", "search.container.page.default.delta");
        fallbackKeys.add("rssDisplayStyle", "rss.feed.display.style.default");
        fallbackKeys.add("rssFeedType", "rss.feed.type.default");
        fallbackKeys.add("subscribeByDefault", "message.boards.subscribe.by.default");
        fallbackKeys.add("threadAsQuestionByDefault", "message.boards.thread.as.question.by.default");
        return fallbackKeys;
    }

    static {
        SettingsFactoryUtil.registerSettingsMetadata(MBGroupServiceSettings.class, null, MBGroupServiceSettings._getFallbackKeys());
    }
}

