/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mentions.matcher;

import com.liferay.mentions.matcher.MentionsMatcher;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseRegularExpressionMentionsMatcher
implements MentionsMatcher {
    private volatile Pattern _pattern;

    @Override
    public Iterable<String> match(String s) {
        return new MentionsIterable(this.getMatcher(s));
    }

    protected Matcher getMatcher(String s) {
        if (this._pattern == null) {
            this._pattern = Pattern.compile(this.getRegularExpression());
        }
        return this._pattern.matcher(s);
    }

    protected abstract String getRegularExpression();

    private static class MentionsIterator
    implements Iterator<String> {
        private Boolean _hasNext;
        private final Matcher _matcher;

        public MentionsIterator(Matcher matcher) {
            this._matcher = matcher;
        }

        @Override
        public boolean hasNext() {
            if (this._hasNext == null) {
                this._hasNext = this._matcher.find();
            }
            return this._hasNext;
        }

        @Override
        public String next() {
            if (this._hasNext == null) {
                this._hasNext = this.hasNext();
            }
            if (!this._hasNext.booleanValue()) {
                throw new NoSuchElementException();
            }
            this._hasNext = null;
            return this._matcher.group(1);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MentionsIterable
    implements Iterable<String> {
        private final Matcher _matcher;

        public MentionsIterable(Matcher matcher) {
            this._matcher = matcher;
        }

        @Override
        public Iterator<String> iterator() {
            this._matcher.reset();
            return new MentionsIterator(this._matcher);
        }
    }
}

