/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.map.taglib.servlet.taglib;

import com.liferay.map.MapProvider;
import com.liferay.map.taglib.internal.servlet.ServletContextUtil;
import com.liferay.map.util.MapProviderHelperUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.util.IncludeTag;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class MapDisplayTag
extends IncludeTag {
    private static final String _PAGE = "/map_display/page.jsp";
    private boolean _geolocation;
    private double _latitude;
    private double _longitude;
    private String _mapProviderKey;
    private String _name;
    private String _points;

    public double getLatitude() {
        return this._latitude;
    }

    public double getLongitude() {
        return this._longitude;
    }

    public String getMapProviderKey() {
        return this._mapProviderKey;
    }

    public String getName() {
        return this._name;
    }

    public String getPoints() {
        return this._points;
    }

    public boolean isGeolocation() {
        return this._geolocation;
    }

    public void setGeolocation(boolean geolocation) {
        this._geolocation = geolocation;
    }

    public void setLatitude(double latitude) {
        this._latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this._longitude = longitude;
    }

    public void setMapProviderKey(String mapProviderKey) {
        this._mapProviderKey = mapProviderKey;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.servletContext = ServletContextUtil.getServletContext();
    }

    public void setPoints(String points) {
        this._points = points;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._geolocation = false;
        this._latitude = 0.0;
        this._longitude = 0.0;
        this._mapProviderKey = null;
        this._name = null;
        this._points = null;
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("liferay-map:map:geolocation", (Object)this._geolocation);
        httpServletRequest.setAttribute("liferay-map:map:latitude", (Object)this._latitude);
        httpServletRequest.setAttribute("liferay-map:map:longitude", (Object)this._longitude);
        httpServletRequest.setAttribute("liferay-map:map:mapProvider", (Object)this._getMapProvider());
        httpServletRequest.setAttribute("liferay-map:map:name", (Object)this._name);
        httpServletRequest.setAttribute("liferay-map:map:points", (Object)this._points);
    }

    private MapProvider _getMapProvider() {
        Collection<MapProvider> mapProviders;
        Iterator<MapProvider> iterator;
        String mapProviderKey = this._getMapProviderKey();
        MapProvider mapProvider = null;
        if (Validator.isNotNull(mapProviderKey)) {
            mapProvider = ServletContextUtil.getMapProvider(mapProviderKey);
        }
        if (mapProvider == null && (iterator = (mapProviders = ServletContextUtil.getMapProviders()).iterator()).hasNext()) {
            mapProvider = iterator.next();
        }
        return mapProvider;
    }

    private String _getMapProviderKey() {
        String mapProdiverKey = this._mapProviderKey;
        if (Validator.isNull(mapProdiverKey)) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            mapProdiverKey = MapProviderHelperUtil.getMapProviderKey(ServletContextUtil.getGroupLocalService(), themeDisplay.getCompanyId(), themeDisplay.getSiteGroupId());
        }
        return mapProdiverKey;
    }
}

