/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.util;

import com.liferay.mail.kernel.model.Filter;
import com.liferay.mail.kernel.util.Hook;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.LoggingOutputProcessor;
import com.liferay.petra.process.ProcessUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsUtil;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import java.util.Map;

public class SendmailHook
implements Hook {
    private static final Log _log = LogFactoryUtil.getLog(SendmailHook.class);

    @Override
    public void addForward(long companyId, long userId, List<Filter> filters, List<String> emailAddresses, boolean leaveCopy) {
        try {
            if (emailAddresses != null) {
                String home = PropsUtil.get("mail.hook.sendmail.home");
                File file = new File(StringBundler.concat(home, "/", userId, "/.forward"));
                if (!emailAddresses.isEmpty()) {
                    StringBundler sb = new StringBundler(emailAddresses.size() * 2);
                    for (String emailAddress : emailAddresses) {
                        sb.append(emailAddress);
                        sb.append("\n");
                    }
                    FileUtil.write(file, sb.toString());
                } else {
                    file.delete();
                }
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    @Override
    public void addUser(long companyId, long userId, String password, String firstName, String middleName, String lastName, String emailAddress) {
        String addUserCmd = PropsUtil.get("mail.hook.sendmail.add.user");
        addUserCmd = StringUtil.replace(addUserCmd, "%1%", String.valueOf(userId));
        try {
            NoticeableFuture<Map.Entry<Void, Void>> future = ProcessUtil.execute(new LoggingOutputProcessor((stdErr, line) -> {
                if (stdErr.booleanValue()) {
                    _log.error(line);
                } else if (_log.isInfoEnabled()) {
                    _log.info(line);
                }
            }), StringUtil.split(addUserCmd, " "));
            future.get();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        this.updatePassword(companyId, userId, password);
        this.updateEmailAddress(companyId, userId, emailAddress);
    }

    @Override
    public void addVacationMessage(long companyId, long userId, String emailAddress, String vacationMessage) {
    }

    @Override
    public void deleteEmailAddress(long companyId, long userId) {
        this.updateEmailAddress(companyId, userId, "");
    }

    @Override
    public void deleteUser(long companyId, long userId) {
        this.deleteEmailAddress(companyId, userId);
        String deleteUserCmd = PropsUtil.get("mail.hook.sendmail.delete.user");
        deleteUserCmd = StringUtil.replace(deleteUserCmd, "%1%", String.valueOf(userId));
        try {
            NoticeableFuture<Map.Entry<Void, Void>> future = ProcessUtil.execute(new LoggingOutputProcessor((stdErr, line) -> {
                if (stdErr.booleanValue()) {
                    _log.error(line);
                } else if (_log.isInfoEnabled()) {
                    _log.info(line);
                }
            }), StringUtil.split(deleteUserCmd, " "));
            future.get();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    @Override
    public void updateBlocked(long companyId, long userId, List<String> blocked) {
        String home = PropsUtil.get("mail.hook.sendmail.home");
        File file = new File(StringBundler.concat(home, "/", userId, "/.procmailrc"));
        if (ListUtil.isEmpty(blocked)) {
            file.delete();
            return;
        }
        StringBundler sb = new StringBundler(blocked.size() * 9 + 3);
        sb.append("ORGMAIL /var/spool/mail/$LOGNAME\n");
        sb.append("MAILDIR $HOME/\n");
        sb.append("SENDMAIL /usr/smin/sendmail\n");
        for (String emailAddress : blocked) {
            sb.append("\n");
            sb.append(":0\n");
            sb.append("* ^From.*");
            sb.append(emailAddress);
            sb.append("\n");
            sb.append("{\n");
            sb.append(":0\n");
            sb.append("/dev/null\n");
            sb.append("}\n");
        }
        try {
            FileUtil.write(file, sb.toString());
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    @Override
    public void updateEmailAddress(long companyId, long userId, String emailAddress) {
        try {
            String virtusertable = PropsUtil.get("mail.hook.sendmail.virtusertable");
            StringBundler sb = new StringBundler();
            try (FileReader fileReader = new FileReader(virtusertable);
                 UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(fileReader);){
                String s = unsyncBufferedReader.readLine();
                while (s != null) {
                    if (!s.endsWith(" " + userId)) {
                        sb.append(s);
                        sb.append('\n');
                    }
                    s = unsyncBufferedReader.readLine();
                }
                if (emailAddress != null && !emailAddress.equals("")) {
                    sb.append(emailAddress);
                    sb.append(" ");
                    sb.append(userId);
                    sb.append('\n');
                }
            }
            FileUtil.write(virtusertable, sb.toString());
            String virtusertableRefreshCmd = PropsUtil.get("mail.hook.sendmail.virtusertable.refresh");
            NoticeableFuture<Map.Entry<Void, Void>> future = ProcessUtil.execute(new LoggingOutputProcessor((stdErr, line) -> {
                if (stdErr.booleanValue()) {
                    _log.error(line);
                } else if (_log.isInfoEnabled()) {
                    _log.info(line);
                }
            }), StringUtil.split(virtusertableRefreshCmd, " "));
            future.get();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    @Override
    public void updatePassword(long companyId, long userId, String password) {
        String changePasswordCmd = PropsUtil.get("mail.hook.sendmail.change.password");
        String[] arguments = StringUtil.split(changePasswordCmd, " ");
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i].equals("%1%")) {
                arguments[i] = String.valueOf(userId);
                continue;
            }
            if (!arguments[i].equals("%2%")) continue;
            arguments[i] = password;
        }
        try {
            NoticeableFuture<Map.Entry<Void, Void>> future = ProcessUtil.execute(new LoggingOutputProcessor((stdErr, line) -> {
                if (stdErr.booleanValue()) {
                    _log.error(line);
                } else if (_log.isInfoEnabled()) {
                    _log.info(line);
                }
            }), arguments);
            future.get();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }
}

