/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.service.impl;

import com.liferay.mail.kernel.model.Filter;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.mail.kernel.util.Hook;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Session;

public class MailServiceImpl
implements IdentifiableOSGiService,
MailService {
    private static final Log _log = LogFactoryUtil.getLog(MailServiceImpl.class);
    private static final MethodKey _addForwardMethodKey = new MethodKey(Hook.class, "addForward", Long.TYPE, Long.TYPE, List.class, List.class, Boolean.TYPE);
    private static final MethodKey _addUserMethodKey = new MethodKey(Hook.class, "addUser", Long.TYPE, Long.TYPE, String.class, String.class, String.class, String.class, String.class);
    private static final MethodKey _addVacationMessageMethodKey = new MethodKey(Hook.class, "addVacationMessage", Long.TYPE, Long.TYPE, String.class, String.class);
    private static final MethodKey _deleteEmailAddressMethodKey = new MethodKey(Hook.class, "deleteEmailAddress", Long.TYPE, Long.TYPE);
    private static final MethodKey _deleteUserMethodKey = new MethodKey(Hook.class, "deleteUser", Long.TYPE, Long.TYPE);
    private static final MethodKey _updateBlockedMethodKey = new MethodKey(Hook.class, "updateBlocked", Long.TYPE, Long.TYPE, List.class);
    private static final MethodKey _updateEmailAddressMethodKey = new MethodKey(Hook.class, "updateEmailAddress", Long.TYPE, Long.TYPE, String.class);
    private static final MethodKey _updatePasswordMethodKey = new MethodKey(Hook.class, "updatePassword", Long.TYPE, Long.TYPE, String.class);
    private Session _session;

    @Override
    public void addForward(long companyId, long userId, List<Filter> filters, List<String> emailAddresses, boolean leaveCopy) {
        if (_log.isDebugEnabled()) {
            _log.debug("addForward");
        }
        MethodHandler methodHandler = new MethodHandler(_addForwardMethodKey, companyId, userId, filters, emailAddresses, leaveCopy);
        MessageBusUtil.sendMessage("liferay/mail", methodHandler);
    }

    @Override
    public void addUser(long companyId, long userId, String password, String firstName, String middleName, String lastName, String emailAddress) {
        if (_log.isDebugEnabled()) {
            _log.debug("addUser");
        }
        MethodHandler methodHandler = new MethodHandler(_addUserMethodKey, companyId, userId, password, firstName, middleName, lastName, emailAddress);
        MessageBusUtil.sendMessage("liferay/mail", methodHandler);
    }

    @Override
    public void addVacationMessage(long companyId, long userId, String emailAddress, String vacationMessage) {
        if (_log.isDebugEnabled()) {
            _log.debug("addVacationMessage");
        }
        MethodHandler methodHandler = new MethodHandler(_addVacationMessageMethodKey, companyId, userId, emailAddress, vacationMessage);
        MessageBusUtil.sendMessage("liferay/mail", methodHandler);
    }

    @Override
    @Clusterable
    public void clearSession() {
        this._session = null;
    }

    @Override
    public void deleteEmailAddress(long companyId, long userId) {
        if (_log.isDebugEnabled()) {
            _log.debug("deleteEmailAddress");
        }
        MethodHandler methodHandler = new MethodHandler(_deleteEmailAddressMethodKey, companyId, userId);
        MessageBusUtil.sendMessage("liferay/mail", methodHandler);
    }

    @Override
    public void deleteUser(long companyId, long userId) {
        if (_log.isDebugEnabled()) {
            _log.debug("deleteUser");
        }
        MethodHandler methodHandler = new MethodHandler(_deleteUserMethodKey, companyId, userId);
        MessageBusUtil.sendMessage("liferay/mail", methodHandler);
    }

    @Override
    public String getOSGiServiceIdentifier() {
        return MailService.class.getName();
    }

    @Override
    public Session getSession() {
        Properties properties;
        block9: {
            if (this._session != null) {
                return this._session;
            }
            Session session = InfrastructureUtil.getMailSession();
            if (!PrefsPropsUtil.getBoolean("mail.session.mail", PropsValues.MAIL_SESSION_MAIL)) {
                this._session = session;
                return this._session;
            }
            String advancedPropertiesString = PrefsPropsUtil.getString("mail.session.mail.advanced.properties", PropsValues.MAIL_SESSION_MAIL_ADVANCED_PROPERTIES);
            String pop3Host = PrefsPropsUtil.getString("mail.session.mail.pop3.host", PropsValues.MAIL_SESSION_MAIL_POP3_HOST);
            String pop3Password = PrefsPropsUtil.getString("mail.session.mail.pop3.password", PropsValues.MAIL_SESSION_MAIL_POP3_PASSWORD);
            int pop3Port = PrefsPropsUtil.getInteger("mail.session.mail.pop3.port", PropsValues.MAIL_SESSION_MAIL_POP3_PORT);
            String pop3User = PrefsPropsUtil.getString("mail.session.mail.pop3.user", PropsValues.MAIL_SESSION_MAIL_POP3_USER);
            String smtpHost = PrefsPropsUtil.getString("mail.session.mail.smtp.host", PropsValues.MAIL_SESSION_MAIL_SMTP_HOST);
            String smtpPassword = PrefsPropsUtil.getString("mail.session.mail.smtp.password", PropsValues.MAIL_SESSION_MAIL_SMTP_PASSWORD);
            int smtpPort = PrefsPropsUtil.getInteger("mail.session.mail.smtp.port", PropsValues.MAIL_SESSION_MAIL_SMTP_PORT);
            String smtpUser = PrefsPropsUtil.getString("mail.session.mail.smtp.user", PropsValues.MAIL_SESSION_MAIL_SMTP_USER);
            String storeProtocol = PrefsPropsUtil.getString("mail.session.mail.store.protocol", PropsValues.MAIL_SESSION_MAIL_STORE_PROTOCOL);
            String transportProtocol = PrefsPropsUtil.getString("mail.session.mail.transport.protocol", PropsValues.MAIL_SESSION_MAIL_TRANSPORT_PROTOCOL);
            properties = session.getProperties();
            if (!storeProtocol.equals("pop3s")) {
                storeProtocol = "pop3";
            }
            properties.setProperty("mail.store.protocol", storeProtocol);
            String storePrefix = "mail." + storeProtocol + ".";
            properties.setProperty(storePrefix + "host", pop3Host);
            properties.setProperty(storePrefix + "password", pop3Password);
            properties.setProperty(storePrefix + "port", String.valueOf(pop3Port));
            properties.setProperty(storePrefix + "user", pop3User);
            if (!transportProtocol.equals("smtps")) {
                transportProtocol = "smtp";
            }
            properties.setProperty("mail.transport.protocol", transportProtocol);
            String transportPrefix = "mail." + transportProtocol + ".";
            boolean smtpAuth = false;
            if (Validator.isNotNull(smtpPassword) || Validator.isNotNull(smtpUser)) {
                smtpAuth = true;
            }
            properties.setProperty(transportPrefix + "auth", String.valueOf(smtpAuth));
            properties.setProperty(transportPrefix + "host", smtpHost);
            properties.setProperty(transportPrefix + "password", smtpPassword);
            properties.setProperty(transportPrefix + "port", String.valueOf(smtpPort));
            properties.setProperty(transportPrefix + "user", smtpUser);
            try {
                if (Validator.isNotNull(advancedPropertiesString)) {
                    Properties advancedProperties = PropertiesUtil.load(advancedPropertiesString);
                    for (Map.Entry<Object, Object> entry : advancedProperties.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        properties.setProperty(key, value);
                    }
                }
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block9;
                _log.warn(ioe, ioe);
            }
        }
        this._session = Session.getInstance((Properties)properties);
        return this._session;
    }

    @Override
    public void sendEmail(MailMessage mailMessage) {
        if (_log.isDebugEnabled()) {
            _log.debug("sendEmail");
        }
        MessageBusUtil.sendMessage("liferay/mail", mailMessage);
    }

    @Override
    public void updateBlocked(long companyId, long userId, List<String> blocked) {
        if (_log.isDebugEnabled()) {
            _log.debug("updateBlocked");
        }
        MethodHandler methodHandler = new MethodHandler(_updateBlockedMethodKey, companyId, userId, blocked);
        MessageBusUtil.sendMessage("liferay/mail", methodHandler);
    }

    @Override
    public void updateEmailAddress(long companyId, long userId, String emailAddress) {
        if (_log.isDebugEnabled()) {
            _log.debug("updateEmailAddress");
        }
        MethodHandler methodHandler = new MethodHandler(_updateEmailAddressMethodKey, companyId, userId, emailAddress);
        MessageBusUtil.sendMessage("liferay/mail", methodHandler);
    }

    @Override
    public void updatePassword(long companyId, long userId, String password) {
        if (_log.isDebugEnabled()) {
            _log.debug("updatePassword");
        }
        MethodHandler methodHandler = new MethodHandler(_updatePasswordMethodKey, companyId, userId, password);
        MessageBusUtil.sendMessage("liferay/mail", methodHandler);
    }
}

