/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.taglib.servlet.taglib.soy;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.frontend.taglib.soy.servlet.taglib.ComponentRendererTag;
import com.liferay.frontend.taglib.util.TagAccessor;
import com.liferay.frontend.taglib.util.TagResourceHandler;
import com.liferay.layout.taglib.internal.frontend.js.loader.modules.extender.npm.NPMResolverProvider;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class SelectLayoutTag
extends ComponentRendererTag {
    private final TagResourceHandler _tagResourceHandler = new TagResourceHandler(SelectLayoutTag.class, new TagAccessor(){

        @Override
        public PageContext getPageContext() {
            return SelectLayoutTag.this._getPageContext();
        }

        @Override
        public HttpServletRequest getRequest() {
            return SelectLayoutTag.this.getRequest();
        }
    });

    @Override
    public int doStartTag() {
        Map<String, Object> context = this.getContext();
        if (context.get("followURLOnTitleClick") == null) {
            this.putValue("followURLOnTitleClick", false);
        }
        if (context.get("itemSelectorSaveEvent") == null) {
            this.putValue("itemSelectorSaveEvent", context.get("namespace") + "selectLayout");
        }
        try {
            this.putValue("nodes", this._getLayoutsJSONArray());
        }
        catch (Exception e) {
            return 0;
        }
        if (context.get("multiSelection") == null) {
            this.putValue("multiSelection", false);
        }
        if (context.get("viewType") == null) {
            this.putValue("viewType", "tree");
        }
        this.setTemplateNamespace("com.liferay.layout.taglib.SelectLayout.render");
        this._tagResourceHandler.outputBundleStyleSheet("select_layout/css/main.css");
        return super.doStartTag();
    }

    @Override
    public String getModule() {
        NPMResolver npmResolver = NPMResolverProvider.getNPMResolver();
        if (npmResolver == null) {
            return "";
        }
        return npmResolver.resolveModuleName("layout-taglib/select_layout/js/SelectLayout.es");
    }

    public void setCheckDisplayPage(boolean checkDisplayPage) {
        this.putValue("checkDisplayPage", checkDisplayPage);
    }

    public void setEnableCurrentPage(boolean enableCurrentPage) {
        this.putValue("enableCurrentPage", enableCurrentPage);
    }

    public void setFollowURLOnTitleClick(boolean followURLOnTitleClick) {
        this.putValue("followURLOnTitleClick", followURLOnTitleClick);
    }

    public void setItemSelectorSaveEvent(String itemSelectorSaveEvent) {
        this.putValue("itemSelectorSaveEvent", itemSelectorSaveEvent);
    }

    public void setMultiSelection(boolean multiSelection) {
        this.putValue("multiSelection", multiSelection);
    }

    public void setNamespace(String namespace) {
        this.putValue("namespace", namespace);
    }

    public void setPathThemeImages(String pathThemeImages) {
        this.putValue("pathThemeImages", pathThemeImages);
    }

    public void setPrivateLayout(boolean privateLayout) {
        this.putValue("privateLayout", privateLayout);
    }

    public void setShowHiddenLayouts(boolean showHiddenLayouts) {
        this.putValue("showHiddenLayouts", showHiddenLayouts);
    }

    public void setViewType(String viewType) {
        this.putValue("viewType", viewType);
    }

    private String _getLayoutBreadcrumb(Layout layout) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Locale locale = themeDisplay.getLocale();
        List<Layout> ancestors = layout.getAncestors();
        StringBundler sb = new StringBundler(4 * ancestors.size() + 5);
        if (layout.isPrivateLayout()) {
            sb.append(LanguageUtil.get(this.request, "private-pages"));
        } else {
            sb.append(LanguageUtil.get(this.request, "public-pages"));
        }
        sb.append(" ");
        sb.append(">");
        sb.append(" ");
        Collections.reverse(ancestors);
        for (Layout ancestor : ancestors) {
            sb.append(HtmlUtil.escape(ancestor.getName(locale)));
            sb.append(" ");
            sb.append(">");
            sb.append(" ");
        }
        sb.append(HtmlUtil.escape(layout.getName(locale)));
        return sb.toString();
    }

    private JSONArray _getLayoutsJSONArray() throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String layoutUuid = ParamUtil.getString(this.request, "layoutUuid");
        JSONArray jsonArray = this._getLayoutsJSONArray(themeDisplay.getScopeGroupId(), this._getPrivateLayout(), 0L, layoutUuid);
        JSONObject jsonObject = JSONUtil.put("children", (Object)jsonArray).put("disabled", true).put("expanded", true).put("icon", "home").put("id", "0").put("name", themeDisplay.getScopeGroupName());
        return JSONUtil.put((Object)jsonObject);
    }

    private JSONArray _getLayoutsJSONArray(long groupId, boolean privateLayout, long parentLayoutId, String selectedLayoutUuid) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List<Layout> layouts = LayoutLocalServiceUtil.getLayouts(groupId, privateLayout, parentLayoutId);
        for (Layout layout : layouts) {
            if (layout.isHidden() && !this._isShowHiddenLayouts() || Objects.equals(layout.getType(), "content") && Objects.equals(layout.getCreateDate(), layout.getPublishDate()) || StagingUtil.isIncomplete(layout)) continue;
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            JSONArray childrenJSONArray = this._getLayoutsJSONArray(groupId, privateLayout, layout.getLayoutId(), selectedLayoutUuid);
            if (childrenJSONArray.length() > 0) {
                jsonObject.put("children", childrenJSONArray);
            }
            if (this._isCheckDisplayPage() && !layout.isContentDisplayPage() || !this._isEnableCurrentPage() && layout.getPlid() == this._getSelPlid()) {
                jsonObject.put("disabled", true);
            }
            jsonObject.put("groupId", layout.getGroupId()).put("icon", "page").put("id", layout.getUuid()).put("layoutId", layout.getLayoutId()).put("name", layout.getName(themeDisplay.getLocale())).put("privateLayout", layout.isPrivateLayout()).put("url", PortalUtil.getLayoutRelativeURL(layout, themeDisplay));
            if (Objects.equals(layout.getUuid(), selectedLayoutUuid)) {
                jsonObject.put("selected", true);
            }
            jsonObject.put("value", this._getLayoutBreadcrumb(layout));
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    private PageContext _getPageContext() {
        return this.pageContext;
    }

    private boolean _getPrivateLayout() {
        Map<String, Object> context = this.getContext();
        return GetterUtil.getBoolean(context.get("privateLayout"));
    }

    private long _getSelPlid() {
        return ParamUtil.getLong(this.request, "selPlid", 0L);
    }

    private boolean _isCheckDisplayPage() {
        Map<String, Object> context = this.getContext();
        return GetterUtil.getBoolean(context.get("checkDisplayPage"));
    }

    private boolean _isEnableCurrentPage() {
        Map<String, Object> context = this.getContext();
        return GetterUtil.getBoolean(context.get("enableCurrentPage"));
    }

    private boolean _isShowHiddenLayouts() {
        Map<String, Object> context = this.getContext();
        return GetterUtil.getBoolean(context.get("showHiddenLayouts"));
    }
}

